/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.annotation.HandlerChainImpl;
import org.ocpsoft.rewrite.annotation.ParameterImpl;
import org.ocpsoft.rewrite.annotation.api.ClassContext;
import org.ocpsoft.rewrite.annotation.api.ClassVisitor;
import org.ocpsoft.rewrite.annotation.context.ClassContextImpl;
import org.ocpsoft.rewrite.annotation.context.FieldContextImpl;
import org.ocpsoft.rewrite.annotation.context.MethodContextImpl;
import org.ocpsoft.rewrite.annotation.context.ParameterContextImpl;
import org.ocpsoft.rewrite.annotation.spi.AnnotationHandler;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Rule;

public class ClassVisitorImpl
implements ClassVisitor,
Configuration {
    private final Logger log = Logger.getLogger(ClassVisitorImpl.class);
    private final List<AnnotationHandler<Annotation>> handlerList;
    private final ConfigurationBuilder builder = ConfigurationBuilder.begin();
    private Object payload;

    public ClassVisitorImpl(List<AnnotationHandler<Annotation>> handlers, Object payload) {
        this.handlerList = new ArrayList<AnnotationHandler<Annotation>>(handlers);
        Collections.sort(this.handlerList, new WeightedComparator());
        this.payload = payload;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Initialized to use {} AnnotationHandlers..", handlers.size());
        }
    }

    @Override
    public void visit(Class<?> clazz) {
        ClassContextImpl context = new ClassContextImpl(this.builder, clazz);
        context.put(clazz, this.payload);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Scanning class: {}", clazz.getName());
        }
        this.visit(clazz, context);
        if (context.hasRuleBuildingStarted()) {
            for (Class<?> currentType = clazz; currentType != null; currentType = currentType.getSuperclass()) {
                for (Field field : currentType.getDeclaredFields()) {
                    this.visit(field, new FieldContextImpl(context, field));
                }
                for (AccessibleObject accessibleObject : currentType.getDeclaredMethods()) {
                    MethodContextImpl methodContext = new MethodContextImpl(context, (Method)accessibleObject);
                    this.visit(accessibleObject, methodContext);
                    for (int i = 0; i < ((Method)accessibleObject).getParameterTypes().length; ++i) {
                        ParameterImpl parameter = new ParameterImpl((Method)accessibleObject, ((Method)accessibleObject).getParameterTypes()[i], ((Method)accessibleObject).getParameterAnnotations()[i], i);
                        this.visit(parameter, new ParameterContextImpl(methodContext, parameter));
                    }
                }
            }
        }
    }

    private void visit(AnnotatedElement element, ClassContext context) {
        ArrayList<AnnotationHandler<Annotation>> elementHandlers = new ArrayList<AnnotationHandler<Annotation>>();
        for (AnnotationHandler<Annotation> handler : this.handlerList) {
            for (Annotation annotation : element.getAnnotations()) {
                if (!handler.handles().equals(annotation.annotationType())) continue;
                elementHandlers.add(handler);
            }
        }
        if (!elementHandlers.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Executing handler chain on " + element + ": " + elementHandlers);
            }
            new HandlerChainImpl(context, element, elementHandlers).proceed();
        }
    }

    @Override
    public List<Rule> getRules() {
        return this.builder.getRules();
    }
}

