/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CompositeMap<KEYTYPE, VALUETYPE>
implements Map<KEYTYPE, VALUETYPE> {
    private Map<KEYTYPE, VALUETYPE>[] delegates = new Map[0];

    public CompositeMap<KEYTYPE, VALUETYPE> addDelegate(Map<KEYTYPE, VALUETYPE> delegate) {
        ArrayList<Map<KEYTYPE, VALUETYPE>> temp = new ArrayList<Map<KEYTYPE, VALUETYPE>>(Arrays.asList(this.delegates));
        temp.add(delegate);
        this.delegates = temp.toArray(new Map[0]);
        return this;
    }

    @Override
    public void clear() {
        for (Map<KEYTYPE, VALUETYPE> delegate : this.delegates) {
            delegate.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map<KEYTYPE, VALUETYPE> delegate : this.delegates) {
            if (!delegate.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map<KEYTYPE, VALUETYPE> delegate : this.delegates) {
            if (!delegate.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<KEYTYPE, VALUETYPE>> entrySet() {
        LinkedHashSet<Map.Entry<KEYTYPE, VALUETYPE>> entries = new LinkedHashSet<Map.Entry<KEYTYPE, VALUETYPE>>();
        for (Map<KEYTYPE, VALUETYPE> delegate : this.delegates) {
            entries.addAll(delegate.entrySet());
        }
        return entries;
    }

    @Override
    public VALUETYPE get(Object key) {
        VALUETYPE result = null;
        for (Map<KEYTYPE, VALUETYPE> delegate : this.delegates) {
            VALUETYPE v = delegate.get(key);
            if (v == null) continue;
            result = v;
            break;
        }
        return result;
    }

    public Object clone() {
        LinkedHashMap<KEYTYPE, VALUETYPE> result = new LinkedHashMap<KEYTYPE, VALUETYPE>();
        result.putAll(this);
        for (Map<KEYTYPE, VALUETYPE> delegate : this.delegates) {
            result.putAll(delegate);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean empty = true;
        for (Map<KEYTYPE, VALUETYPE> delegate : this.delegates) {
            if (delegate.isEmpty()) continue;
            empty = false;
            break;
        }
        return empty;
    }

    @Override
    public Set<KEYTYPE> keySet() {
        LinkedHashSet<KEYTYPE> result = new LinkedHashSet<KEYTYPE>();
        for (Map<KEYTYPE, VALUETYPE> delegate : this.delegates) {
            result.addAll(delegate.keySet());
        }
        return result;
    }

    @Override
    public VALUETYPE put(KEYTYPE key, VALUETYPE value) {
        throw new UnsupportedOperationException("Cannot add values to composite map view.");
    }

    @Override
    public void putAll(Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        throw new UnsupportedOperationException("Cannot add values to composite map view.");
    }

    @Override
    public VALUETYPE remove(Object key) {
        throw new UnsupportedOperationException("Cannot remove values from composite map view.");
    }

    @Override
    public int size() {
        int size = 0;
        for (Map<KEYTYPE, VALUETYPE> delegate : this.delegates) {
            size += delegate.size();
        }
        return size;
    }

    @Override
    public Collection<VALUETYPE> values() {
        LinkedHashSet<VALUETYPE> values = new LinkedHashSet<VALUETYPE>();
        for (Map<KEYTYPE, VALUETYPE> delegate : this.delegates) {
            values.addAll(delegate.values());
        }
        return values;
    }
}

