/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.Retrieval;
import org.ocpsoft.rewrite.bind.Submission;
import org.ocpsoft.rewrite.config.DefaultConditionBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;

public abstract class Bindings {
    public static boolean enqueueSubmission(Rewrite event, EvaluationContext context, Bindable bindable, Object value) {
        LinkedHashMap<Bindable, Object> map = new LinkedHashMap<Bindable, Object>();
        map.put(bindable, value);
        return Bindings.enqueuePreOperationSubmissions(event, context, map);
    }

    public static boolean enqueuePreOperationSubmissions(Rewrite event, EvaluationContext context, Map<? extends Bindable, ? extends Object> map) {
        ArrayList<BindingOperation> operations = new ArrayList<BindingOperation>();
        for (Map.Entry<? extends Bindable, ? extends Object> entry : map.entrySet()) {
            Bindable parameter = entry.getKey();
            Object value = entry.getValue();
            List<Binding> bindings = parameter.getBindings();
            try {
                for (Binding binding : bindings) {
                    try {
                        Object convertedValue;
                        if (binding instanceof Evaluation) {
                            convertedValue = binding.convert(event, context, value);
                            if (binding.validate(event, context, convertedValue)) {
                                binding.submit(event, context, value);
                                continue;
                            }
                            return false;
                        }
                        convertedValue = binding.convert(event, context, value);
                        if (binding.validate(event, context, convertedValue)) {
                            convertedValue = binding.convert(event, context, convertedValue);
                            operations.add(new BindingOperation(binding, convertedValue));
                            continue;
                        }
                        return false;
                    }
                    catch (Exception e) {
                        throw new RewriteException("Failed to bind value [" + value + "] to binding [" + binding + "]", e);
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        }
        for (Operation operation : operations) {
            context.addPreOperation(operation);
        }
        return true;
    }

    public static List<Object> performRetrieval(Rewrite event, EvaluationContext context, Bindable<?> bindable) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Binding binding : bindable.getBindings()) {
            Object boundValue = binding.retrieve(event, context);
            result.add(boundValue);
        }
        return result;
    }

    public static DefaultConditionBuilder equals(final Object expected, final Retrieval binding) {
        return new DefaultConditionBuilder(){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                Object actual = binding.retrieve(event, context);
                return Bindings.compare(expected, actual);
            }
        };
    }

    public static DefaultConditionBuilder equals(final Object expected, final Submission binding, final Object submission) {
        return new DefaultConditionBuilder(){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                Object actual = binding.submit(event, context, submission);
                return Bindings.compare(expected, actual);
            }
        };
    }

    public static DefaultConditionBuilder equals(final Retrieval left, final Retrieval right) {
        return new DefaultConditionBuilder(){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return Bindings.compare(left.retrieve(event, context), right.retrieve(event, context));
            }
        };
    }

    public static DefaultConditionBuilder equals(final Retrieval left, final Submission right, final Object submission) {
        return new DefaultConditionBuilder(){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return Bindings.compare(left.retrieve(event, context), right.submit(event, context, submission));
            }
        };
    }

    public static DefaultConditionBuilder equals(final Submission left, final Object leftSubmission, final Submission right, final Object rightSubmission) {
        return new DefaultConditionBuilder(){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return Bindings.compare(left.submit(event, context, leftSubmission), right.submit(event, context, rightSubmission));
            }
        };
    }

    public static DefaultConditionBuilder notEquals(final Object expected, final Retrieval binding) {
        return new DefaultConditionBuilder(){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                Object actual = binding.retrieve(event, context);
                return !Bindings.compare(expected, actual);
            }
        };
    }

    public static DefaultConditionBuilder notEquals(final Object expected, final Submission binding, final Object submission) {
        return new DefaultConditionBuilder(){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                Object actual = binding.submit(event, context, submission);
                return !Bindings.compare(expected, actual);
            }
        };
    }

    public static DefaultConditionBuilder notEquals(final Retrieval left, final Retrieval right) {
        return new DefaultConditionBuilder(){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return !Bindings.compare(left.retrieve(event, context), right.retrieve(event, context));
            }
        };
    }

    public static DefaultConditionBuilder notEquals(final Retrieval left, final Submission right, final Object submission) {
        return new DefaultConditionBuilder(){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return !Bindings.compare(left.retrieve(event, context), right.submit(event, context, submission));
            }
        };
    }

    public static DefaultConditionBuilder notEquals(final Submission left, final Object leftSubmission, final Submission right, final Object rightSubmission) {
        return new DefaultConditionBuilder(){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return !Bindings.compare(left.submit(event, context, leftSubmission), right.submit(event, context, rightSubmission));
            }
        };
    }

    private static boolean compare(Object expected, Object actual) {
        if (expected == actual) {
            return true;
        }
        return expected != null && expected.equals(actual);
    }

    private static class BindingOperation
    implements Operation {
        private final Binding binding;
        private final Object value;

        public BindingOperation(Binding binding, Object value) {
            this.binding = binding;
            this.value = value;
        }

        @Override
        public void perform(Rewrite event, EvaluationContext context) {
            this.binding.submit(event, context, this.value);
        }

        public String toString() {
            return "BindingOperation [binding=" + this.binding + ", value=" + this.value + "]";
        }
    }
}

