/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilderParameter;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternParserParameter;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.param.Transformations;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.config.ISubstitute;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;

public class Substitute
extends HttpOperation
implements ISubstitute {
    private final ParameterizedPatternParser location;
    private final ParameterStore<ISubstitute.SubstituteParameter> parameters = new ParameterStore();

    private Substitute(String location) {
        Assert.notNull(location, "Location must not be null.");
        this.location = new RegexParameterizedPatternParser("[^/]+", location);
        for (ParameterizedPatternParserParameter parameter : this.location.getParameterMap().values()) {
            this.where(parameter.getName()).bindsTo(Evaluation.property(parameter.getName()));
        }
    }

    public static Substitute with(String location) {
        return new Substitute(location);
    }

    @Override
    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            String target = this.location.getBuilder().build(event, context, this.parameters);
            ((HttpInboundServletRewrite)event).forward(target);
        } else if (event instanceof HttpOutboundServletRewrite) {
            ParameterizedPatternBuilder builder = this.location.getBuilder();
            for (ISubstitute.SubstituteParameter param : this.parameters.values()) {
                ((ParameterizedPatternBuilderParameter)builder.where(param.getName())).transformedBy(Transformations.encodePath());
            }
            String target = builder.build(event, context, this.parameters);
            if (((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).getPath().startsWith(event.getContextPath()) && target.startsWith("/") && !target.startsWith(event.getContextPath())) {
                target = event.getContextPath() + target;
            }
            ((HttpOutboundServletRewrite)event).setOutboundAddress(AddressBuilder.create(target));
        }
    }

    @Override
    public ISubstitute.SubstituteParameter where(String param) {
        return this.parameters.where(param, new ISubstitute.SubstituteParameter(this, (ParameterizedPatternParserParameter)this.location.getParameter(param)));
    }

    @Override
    public ParameterizedPatternParser getTargetExpression() {
        return this.location;
    }
}

