/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.rewrite.param.DefaultParameter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.Parameterized;

public class ParameterStore
implements Iterable<Map.Entry<String, Parameter<?>>> {
    private final Map<String, Parameter<?>> parameters = new LinkedHashMap();

    public static void initialize(ParameterStore store, Parameterized parameterized) {
        Set<String> names = parameterized.getRequiredParameterNames();
        for (String name : names) {
            if (store.contains(name)) continue;
            store.put(name, new DefaultParameter(name));
        }
        parameterized.setParameterStore(store);
    }

    public Parameter<?> where(String param, Parameter<?> deflt) {
        Parameter<?> parameter = null;
        if (this.parameters.get(param) != null) {
            parameter = this.parameters.get(param);
        } else {
            parameter = deflt;
            this.parameters.put(param, parameter);
        }
        return parameter;
    }

    public Parameter<?> get(String key) {
        if (!this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("No such parameter [" + key + "] exists.");
        }
        return this.parameters.get(key);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public Parameter<?> put(String key, Parameter<?> value) {
        return this.parameters.put(key, value);
    }

    public int size() {
        return this.parameters.size();
    }

    @Override
    public Iterator<Map.Entry<String, Parameter<?>>> iterator() {
        return this.parameters.entrySet().iterator();
    }

    public boolean contains(String name) {
        return this.parameters.containsKey(name);
    }

    public String toString() {
        return this.parameters.keySet().toString();
    }
}

