/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transposition;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.param.Parameters;
import org.ocpsoft.rewrite.param.Transposition;

public class LocaleTransposition
implements Transposition<String> {
    private static Map<String, ResourceBundle> bundleMap = new ConcurrentHashMap<String, ResourceBundle>();
    private final String languageParam;
    private final String bundleName;

    private LocaleTransposition(String languageParam, String bundleName) {
        this.languageParam = languageParam;
        this.bundleName = bundleName;
    }

    public static LocaleTransposition bundle(String bundleName, String localeParam) {
        return new LocaleTransposition(localeParam, bundleName);
    }

    @Override
    public String transpose(Rewrite event, EvaluationContext context, String value) {
        String transposedValue = null;
        String targetLang = Parameters.retrieve(context, this.languageParam);
        if (value != null) {
            if (!bundleMap.containsKey(targetLang)) {
                Locale locale = new Locale(targetLang);
                try {
                    ResourceBundle loadedBundle = ResourceBundle.getBundle(this.bundleName, locale);
                    bundleMap.put(targetLang, loadedBundle);
                }
                catch (MissingResourceException e) {
                    throw new RewriteException("Error occurred during Locale transposition of parameter value [" + value + "] via bundle [" + this.bundleName + "_" + targetLang + "]", e);
                }
            }
            if (bundleMap.containsKey(targetLang)) {
                try {
                    transposedValue = bundleMap.get(targetLang).getString(value);
                }
                catch (MissingResourceException mrEx) {
                    transposedValue = value;
                }
            } else {
                transposedValue = value;
            }
        }
        return transposedValue;
    }
}

