/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.spi.ServiceEnricher;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.ConfigurationProvider;
import org.ocpsoft.rewrite.el.spi.ExpressionLanguageProvider;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.ServletRewriteProvider;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.event.InboundServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.HttpRewriteContextImpl;
import org.ocpsoft.rewrite.servlet.spi.ContextListener;
import org.ocpsoft.rewrite.servlet.spi.InboundRewriteProducer;
import org.ocpsoft.rewrite.servlet.spi.OutboundRewriteProducer;
import org.ocpsoft.rewrite.servlet.spi.RequestCycleWrapper;
import org.ocpsoft.rewrite.servlet.spi.RequestListener;
import org.ocpsoft.rewrite.servlet.spi.RequestParameterProvider;
import org.ocpsoft.rewrite.servlet.spi.RewriteLifecycleListener;
import org.ocpsoft.rewrite.spi.ConfigurationCacheProvider;
import org.ocpsoft.rewrite.spi.InvocationResultHandler;
import org.ocpsoft.rewrite.spi.RewriteProvider;
import org.ocpsoft.rewrite.spi.RewriteResultHandler;
import org.ocpsoft.rewrite.util.ServiceLogger;

public class RewriteFilter
implements Filter {
    Logger log = Logger.getLogger(RewriteFilter.class);
    private List<RewriteLifecycleListener<Rewrite>> listeners;
    private List<RequestCycleWrapper<ServletRequest, ServletResponse>> wrappers;
    private List<RewriteProvider<ServletContext, Rewrite>> providers;
    private List<RewriteResultHandler> resultHandlers;
    private List<InboundRewriteProducer<ServletRequest, ServletResponse>> inbound;
    private List<OutboundRewriteProducer<ServletRequest, ServletResponse, Object>> outbound;
    private ServletContext servletContext;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.log.info("RewriteFilter starting up...");
        this.servletContext = filterConfig.getServletContext();
        this.listeners = Iterators.asList(ServiceLoader.load(RewriteLifecycleListener.class));
        this.wrappers = Iterators.asList(ServiceLoader.load(RequestCycleWrapper.class));
        this.providers = Iterators.asList(ServiceLoader.load(RewriteProvider.class));
        this.resultHandlers = Iterators.asList(ServiceLoader.load(RewriteResultHandler.class));
        this.inbound = Iterators.asList(ServiceLoader.load(InboundRewriteProducer.class));
        this.outbound = Iterators.asList(ServiceLoader.load(OutboundRewriteProducer.class));
        Collections.sort(this.listeners, new WeightedComparator());
        Collections.sort(this.wrappers, new WeightedComparator());
        Collections.sort(this.providers, new WeightedComparator());
        Collections.sort(this.resultHandlers, new WeightedComparator());
        Collections.sort(this.inbound, new WeightedComparator());
        Collections.sort(this.outbound, new WeightedComparator());
        ServiceLogger.logLoadedServices(this.log, RewriteLifecycleListener.class, this.listeners);
        ServiceLogger.logLoadedServices(this.log, RequestCycleWrapper.class, this.wrappers);
        ServiceLogger.logLoadedServices(this.log, RewriteProvider.class, this.providers);
        ServiceLogger.logLoadedServices(this.log, RewriteResultHandler.class, this.resultHandlers);
        ServiceLogger.logLoadedServices(this.log, InboundRewriteProducer.class, this.inbound);
        ServiceLogger.logLoadedServices(this.log, OutboundRewriteProducer.class, this.outbound);
        ServiceLogger.logLoadedServices(this.log, ContextListener.class, Iterators.asList(ServiceLoader.load(ContextListener.class)));
        ServiceLogger.logLoadedServices(this.log, RequestListener.class, Iterators.asList(ServiceLoader.load(RequestListener.class)));
        ServiceLogger.logLoadedServices(this.log, RequestParameterProvider.class, Iterators.asList(ServiceLoader.load(RequestParameterProvider.class)));
        ServiceLogger.logLoadedServices(this.log, ExpressionLanguageProvider.class, Iterators.asList(ServiceLoader.load(ExpressionLanguageProvider.class)));
        ServiceLogger.logLoadedServices(this.log, InvocationResultHandler.class, Iterators.asList(ServiceLoader.load(InvocationResultHandler.class)));
        ServiceLogger.logLoadedServices(this.log, ServiceEnricher.class, Iterators.asList(ServiceLoader.load(ServiceEnricher.class)));
        ServiceLogger.logLoadedServices(this.log, ConfigurationCacheProvider.class, Iterators.asList(ServiceLoader.load(ConfigurationCacheProvider.class)));
        List configurations = Iterators.asList(ServiceLoader.load(ConfigurationProvider.class));
        ServiceLogger.logLoadedServices(this.log, ConfigurationProvider.class, configurations);
        for (RewriteProvider<ServletContext, Rewrite> provider : this.providers) {
            if (!(provider instanceof ServletRewriteProvider)) continue;
            ((ServletRewriteProvider)provider).init(this.servletContext);
        }
        if (configurations == null || configurations.isEmpty()) {
            this.log.warn("No ConfigurationProviders were registered: Rewrite will not be enabled on this application. Did you forget to create a '/META-INF/services/" + ConfigurationProvider.class.getName() + " file containing the fully qualified name of your provider implementation?");
        }
        this.log.info("RewriteFilter initialized.");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        InboundServletRewrite<ServletRequest, ServletResponse> event = this.createRewriteEvent(request, response);
        if (event == null) {
            this.log.warn("No Rewrite event was produced - RewriteFilter disabled on this request.");
            chain.doFilter(request, response);
        } else {
            if (request.getAttribute("_com.ocpsoft.rewrite.RequestContext") == null) {
                HttpRewriteContextImpl context = new HttpRewriteContextImpl(this.inbound, this.outbound, this.listeners, this.resultHandlers, this.wrappers, this.providers);
                request.setAttribute("_com.ocpsoft.rewrite.RequestContext", (Object)context);
            }
            for (RewriteLifecycleListener<Rewrite> rewriteLifecycleListener : this.listeners) {
                if (!rewriteLifecycleListener.handles(event)) continue;
                rewriteLifecycleListener.beforeInboundLifecycle(event);
            }
            for (RequestCycleWrapper requestCycleWrapper : this.wrappers) {
                if (!requestCycleWrapper.handles(event)) continue;
                event.setRequest((ServletRequest)requestCycleWrapper.wrapRequest(event.getRequest(), event.getResponse(), this.servletContext));
                event.setResponse((ServletResponse)requestCycleWrapper.wrapResponse(event.getRequest(), event.getResponse(), this.servletContext));
            }
            try {
                this.rewrite(event);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException("Error during Rewrite processing. Please inspect stack trace for root cause.", (Throwable)e);
            }
            if (!event.getFlow().is(BaseRewrite.ServletRewriteFlow.ABORT_REQUEST)) {
                this.log.debug("RewriteFilter passing control of request to underlying application.");
                chain.doFilter(event.getRequest(), event.getResponse());
                this.log.debug("Control of request returned to RewriteFilter.");
            }
            for (RewriteLifecycleListener rewriteLifecycleListener : this.listeners) {
                if (!rewriteLifecycleListener.handles(event)) continue;
                rewriteLifecycleListener.afterInboundLifecycle(event);
            }
        }
    }

    public InboundServletRewrite<ServletRequest, ServletResponse> createRewriteEvent(ServletRequest request, ServletResponse response) {
        for (InboundRewriteProducer<ServletRequest, ServletResponse> producer : this.inbound) {
            InboundServletRewrite<ServletRequest, ServletResponse> event = producer.createInboundRewrite(request, response, this.servletContext);
            if (event == null) continue;
            return event;
        }
        return null;
    }

    private void rewrite(InboundServletRewrite<ServletRequest, ServletResponse> event) throws ServletException, IOException, Exception {
        int i;
        int listenerCount = this.listeners.size();
        for (int i2 = 0; i2 < listenerCount; ++i2) {
            RewriteLifecycleListener<Rewrite> listener = this.listeners.get(i2);
            if (!listener.handles(event)) continue;
            listener.beforeInboundRewrite(event);
        }
        int providerCount = this.providers.size();
        for (i = 0; i < providerCount; ++i) {
            RewriteProvider<ServletContext, Rewrite> provider = this.providers.get(i);
            if (!provider.handles(event)) continue;
            provider.rewrite(event);
            if (!event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) continue;
            this.log.debug("Event flow marked as HANDLED. No further processing will occur.");
            break;
        }
        for (i = 0; i < listenerCount; ++i) {
            RewriteLifecycleListener<Rewrite> listener = this.listeners.get(i);
            if (!listener.handles(event)) continue;
            listener.afterInboundRewrite(event);
        }
        int handlerCount = this.resultHandlers.size();
        for (int i3 = 0; i3 < handlerCount; ++i3) {
            if (!this.resultHandlers.get(i3).handles(event)) continue;
            this.resultHandlers.get(i3).handleResult(event);
        }
    }

    public void destroy() {
        this.log.info("RewriteFilter shutting down...");
        for (RewriteProvider<ServletContext, Rewrite> provider : this.providers) {
            if (!(provider instanceof ServletRewriteProvider)) continue;
            ((ServletRewriteProvider)provider).shutdown(this.servletContext);
        }
        this.log.info("RewriteFilter deactivated.");
    }
}

