/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation.handler;

import java.util.Collection;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.rewrite.annotation.RewriteConfiguration;
import org.ocpsoft.rewrite.annotation.api.ClassContext;
import org.ocpsoft.rewrite.annotation.api.HandlerChain;
import org.ocpsoft.rewrite.annotation.spi.AnnotationHandler;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationProvider;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilder;
import org.ocpsoft.rewrite.config.RelocatableRule;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.exception.RewriteException;

public class RewriteConfigurationHandler
implements AnnotationHandler<RewriteConfiguration> {
    @Override
    public Class<RewriteConfiguration> handles() {
        return RewriteConfiguration.class;
    }

    @Override
    public int priority() {
        return 100;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(ClassContext context, RewriteConfiguration annotation, HandlerChain chain) {
        Class<?> type = context.getJavaClass();
        if (!ConfigurationProvider.class.isAssignableFrom(type) || type.isInterface() || type.isAnnotation() || type.isArray()) throw new RewriteException("Class [" + type.getName() + "] annotated with @" + RewriteConfiguration.class.getSimpleName() + " must implement [" + ConfigurationProvider.class.getName() + "]");
        Class<?> providerType = type;
        Collection<?> enriched = ServiceLoader.loadEnriched(providerType);
        if (enriched.size() == 1) {
            Object configurationContext;
            ConfigurationProvider provider = (ConfigurationProvider)enriched.iterator().next();
            if (!provider.handles(configurationContext = context.get(type))) throw new RewriteException("@" + RewriteConfiguration.class.getSimpleName() + " type [" + type.getName() + "] cannot handle context of type [" + configurationContext + "]");
            Configuration config = provider.getConfiguration(configurationContext);
            for (Rule rule : config.getRules()) {
                ConfigurationRuleBuilder ruleBuilder = context.getConfigurationBuilder().addRule(rule);
                if (rule instanceof RelocatableRule && ((RelocatableRule)rule).isRelocated()) {
                    ruleBuilder.withPriority(((RelocatableRule)rule).priority());
                    continue;
                }
                ruleBuilder.withPriority(provider.priority());
            }
        } else {
            if (enriched.size() < 1) {
                throw new RewriteException("No service of type [" + type.getName() + "] was found while loading configuration.");
            }
            if (enriched.size() > 1) {
                throw new RewriteException("More than one service of type [" + type.getName() + "] was found while loading configuration.");
            }
        }
        chain.proceed();
    }
}

