/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequest;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.common.util.Strings;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.DispatcherType;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.spi.DispatcherTypeProvider;

public class DispatchType
extends HttpCondition {
    private final DispatcherType type;
    private final List<DispatcherTypeProvider> providers;

    private DispatchType(DispatcherType type) {
        this.type = type;
        this.providers = Iterators.asList(ServiceLoader.loadTypesafe(DispatcherTypeProvider.class).iterator());
        Collections.sort(this.providers, new WeightedComparator());
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        return this.type.equals((Object)this.getDispatcherType(event));
    }

    private DispatcherType getDispatcherType(HttpServletRewrite event) {
        for (DispatcherTypeProvider provider : this.providers) {
            DispatcherType dispatcherType = provider.getDispatcherType((ServletRequest)event.getRequest(), event.getServletContext());
            if (dispatcherType == null) continue;
            return dispatcherType;
        }
        throw new IllegalStateException("Unable to determine dispatcher type of current request");
    }

    public static DispatchType isForward() {
        return new DispatchType(DispatcherType.FORWARD);
    }

    public static DispatchType isRequest() {
        return new DispatchType(DispatcherType.REQUEST);
    }

    public static DispatchType isError() {
        return new DispatchType(DispatcherType.ERROR);
    }

    public static DispatchType isAsync() {
        return new DispatchType(DispatcherType.ASYNC);
    }

    public static DispatchType isInclude() {
        return new DispatchType(DispatcherType.INCLUDE);
    }

    public String toString() {
        return "DispatchType.is" + Strings.capitalize(this.type.toString().toLowerCase() + "()");
    }
}

