/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ocpsoft.common.util.Strings;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.RewriteWrappedRequest;
import org.ocpsoft.rewrite.servlet.config.DispatchType;
import org.ocpsoft.rewrite.servlet.config.encodequery.Base64EncodingStrategy;
import org.ocpsoft.rewrite.servlet.config.encodequery.ChecksumStrategy;
import org.ocpsoft.rewrite.servlet.config.encodequery.EncodingStrategy;
import org.ocpsoft.rewrite.servlet.config.encodequery.HashCodeChecksumStrategy;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.util.QueryStringBuilder;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;
import org.ocpsoft.rewrite.util.Maps;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;

public class EncodeQuery
implements Operation {
    private String tokenName;
    private ChecksumStrategy checksumStrategy = new HashCodeChecksumStrategy();
    private EncodingStrategy encodingStrategy = new Base64EncodingStrategy();
    private final List<String> params = new ArrayList<String>();
    private final List<String> excludedParams = new ArrayList<String>();
    private boolean inboundCorrection = true;
    private Operation onfailure;

    private EncodeQuery(String[] params) {
        if (params != null && params.length > 0) {
            this.params.addAll(Arrays.asList(params));
        }
    }

    public static EncodeQuery params(String ... params) {
        return new EncodeQuery(params);
    }

    public EncodeQuery excluding(String ... params) {
        if (params != null && params.length > 0) {
            this.excludedParams.addAll(Arrays.asList(params));
        }
        return this;
    }

    public EncodeQuery withEncodingStrategy(EncodingStrategy strategy) {
        this.encodingStrategy = strategy;
        return this;
    }

    public EncodeQuery withChecksumStrategy(ChecksumStrategy strategy) {
        this.checksumStrategy = strategy;
        return this;
    }

    public EncodeQuery withInboundCorrection(boolean enable) {
        this.inboundCorrection = enable;
        return this;
    }

    public EncodeQuery onChecksumFailure(Operation operation) {
        this.onfailure = operation;
        return this;
    }

    public EncodeQuery to(String param) {
        this.tokenName = param;
        return this;
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite && DispatchType.isRequest().evaluate(event, context)) {
            HttpInboundServletRewrite in = (HttpInboundServletRewrite)event;
            QueryStringBuilder query = QueryStringBuilder.createNew();
            query.addParameters(in.getInboundAddress().getQuery());
            String token = query.decode().getParameter(this.tokenName);
            if (token != null) {
                String decoded = this.encodingStrategy.decode(token);
                if (this.checksumStrategy.checksumValid(decoded)) {
                    decoded = this.checksumStrategy.removeChecksum(decoded);
                    query.removeParameter(this.tokenName);
                    QueryStringBuilder queryParams = QueryStringBuilder.createFromEncoded(decoded);
                    RewriteWrappedRequest request = RewriteWrappedRequest.getCurrentInstance(in.getRequest());
                    for (Map.Entry<String, List<String>> param : queryParams.getParameterMap().entrySet()) {
                        for (String value : param.getValue()) {
                            Maps.addArrayValue(request.getModifiableParameters(), param.getKey(), value);
                        }
                    }
                } else if (this.onfailure != null) {
                    this.onfailure.perform(event, context);
                }
            } else if (!query.isEmpty() && this.inboundCorrection) {
                in.redirectTemporary(in.getAddress().getPathAndQuery());
            }
        } else if (event instanceof HttpOutboundServletRewrite) {
            HttpOutboundServletRewrite out = (HttpOutboundServletRewrite)event;
            String outboundURL = ((Address)out.getOutboundAddress()).toString();
            URLBuilder url = URLBuilder.createFrom(outboundURL);
            url.getQueryStringBuilder().removeParameter(this.tokenName);
            QueryStringBuilder newQuery = QueryStringBuilder.createNew();
            for (String param : this.excludedParams) {
                newQuery.addParameter(param, url.getQueryStringBuilder().removeParameter(param).toArray(new String[0]));
            }
            if (!this.params.isEmpty()) {
                for (String param : url.getQueryStringBuilder().getParameterNames()) {
                    if (this.params.contains(param)) continue;
                    newQuery.addParameter(param, url.getQueryStringBuilder().removeParameter(param).toArray(new String[0]));
                }
            }
            if (outboundURL.contains("?") && (outboundURL.startsWith(out.getContextPath()) || outboundURL.startsWith("/")) && !url.getQueryStringBuilder().isEmpty()) {
                String encoded = this.checksumStrategy.embedChecksum(url.getQueryStringBuilder().toQueryString());
                encoded = this.encodingStrategy.encode(encoded);
                newQuery.addParameter(this.tokenName, encoded);
                out.setOutboundAddress(AddressBuilder.create(url.toPath() + newQuery.toQueryString()));
            }
        }
    }

    public String toString() {
        return "EncodeQuery.params(\"" + Strings.join(this.params, "\", \"") + "\")";
    }
}

