/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.LinkedHashSet;
import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexConstraint;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.bind.RequestBinding;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;
import org.ocpsoft.urlbuilder.Address;

public abstract class PathAndQuery
extends HttpCondition
implements Parameterized {
    private final ParameterizedPatternParser expression;
    private boolean withRequestBinding = false;
    private String captureIn;

    private PathAndQuery(String pattern) {
        Assert.notNull(pattern, "Pattern must not be null.");
        this.expression = new RegexParameterizedPatternParser(".+", pattern);
    }

    public static PathAndQuery matches(final String pattern) {
        return new PathAndQuery(pattern){

            public String toString() {
                return "PathAndQuery.matches(\"" + pattern + "\")";
            }
        };
    }

    public static PathAndQuery captureIn(final String param) {
        PathAndQuery path = new PathAndQuery("{" + param + "}"){

            public String toString() {
                return "PathAndQuery.captureIn(\"" + param + "\")";
            }
        };
        path.captureIn = param;
        return path;
    }

    public PathAndQuery withRequestBinding() {
        this.withRequestBinding = true;
        return this;
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String url = null;
        if (event instanceof HttpOutboundServletRewrite) {
            url = ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).getPathAndQuery();
            if (url == null) {
                return false;
            }
        } else {
            url = URLBuilder.createFrom(event.getInboundAddress().getPathAndQuery()).decode().toURL();
        }
        if (url.startsWith(event.getContextPath())) {
            url = url.substring(event.getContextPath().length());
        }
        return this.expression.matches(event, context, url);
    }

    public ParameterizedPatternParser getExpression() {
        return this.expression;
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.captureIn != null) {
            result.add(this.captureIn);
        } else {
            result.addAll(this.expression.getRequiredParameterNames());
        }
        return result;
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        Parameter<?> parameter;
        if (this.captureIn != null && (parameter = store.get(this.captureIn)) instanceof ConfigurableParameter) {
            ((ConfigurableParameter)parameter).constrainedBy(new RegexConstraint(".*"));
        }
        if (this.withRequestBinding) {
            for (String param : this.getRequiredParameterNames()) {
                Parameter<?> parameter2 = store.get(param);
                if (!(parameter2 instanceof ConfigurableParameter)) continue;
                ((ConfigurableParameter)parameter2).bindsTo(RequestBinding.parameter(param));
            }
            this.withRequestBinding = true;
        }
        this.expression.setParameterStore(store);
    }
}

