/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.urlbuilder;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;
import org.ocpsoft.urlbuilder.Parameter;

class AddressResult
implements Address {
    private final String protocol;
    private final String schemeSpecificPart;
    private final String host;
    private final Integer port;
    private final String path;
    private final String query;
    private final String anchor;
    private CharSequence result;
    private Map<String, List<Object>> queries = Collections.emptyMap();

    public AddressResult(AddressBuilder parent) {
        this.protocol = this.isSet(parent.scheme) ? parent.scheme.toString() : null;
        this.schemeSpecificPart = this.isSet(parent.schemeSpecificPart) ? parent.schemeSpecificPart.toString() : null;
        this.host = this.isSet(parent.domain) ? parent.domain.toString() : null;
        this.port = this.isSet(parent.port) ? parent.port : null;
        if (this.isSet(parent.path)) {
            CharSequence path = parent.path;
            if (path.charAt(0) != '/') {
                path = new StringBuilder(47).append(path);
            }
            this.path = path.toString();
        } else {
            this.path = null;
        }
        if (this.isSet(parent.queries)) {
            this.queries = Collections.unmodifiableMap(parent.getQueries());
            this.query = this.toQuery(parent.queries).toString();
        } else {
            this.query = null;
        }
        this.anchor = this.isSetOrEmpty(parent.anchor) ? parent.anchor.toString() : null;
    }

    private CharSequence toQuery(Map<CharSequence, Parameter> queries) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (CharSequence name : queries.keySet()) {
            Parameter parameter = queries.get(name);
            if (!first) {
                result.append('&');
            } else {
                first = false;
            }
            result.append(name);
            if (parameter.getValueCount() <= 0) continue;
            for (int i = 0; i < parameter.getValueCount(); ++i) {
                String value = parameter.getValue(i);
                if (value != null) {
                    result.append('=').append(value);
                }
                if (i >= parameter.getValueCount() - 1) continue;
                result.append('&').append(name);
            }
        }
        return result;
    }

    public String toString() {
        if (this.result == null) {
            StringBuilder result = AddressBuilder.toString(this);
            this.result = result;
        }
        return this.result.toString();
    }

    private boolean isSet(Integer port) {
        return port != null;
    }

    private boolean isSet(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    private boolean isSet(CharSequence value) {
        return value != null && value.length() > 0;
    }

    private boolean isSetOrEmpty(CharSequence value) {
        return value != null;
    }

    @Override
    public String getAnchor() {
        return this.anchor;
    }

    @Override
    public boolean isAnchorSet() {
        return this.isSetOrEmpty(this.anchor);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getPathAndQuery() {
        StringBuilder result = new StringBuilder();
        if (this.isPathSet()) {
            result.append(this.getPath());
        }
        if (this.isQuerySet()) {
            result.append('?').append(this.getQuery());
        }
        return result.toString();
    }

    @Override
    public boolean isPathSet() {
        return this.isSet(this.path);
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public boolean isPortSet() {
        return this.isSet(this.port);
    }

    @Override
    public String getDomain() {
        return this.host;
    }

    @Override
    public boolean isDomainSet() {
        return this.isSet(this.host);
    }

    @Override
    public String getScheme() {
        return this.protocol;
    }

    @Override
    public boolean isSchemeSet() {
        return this.isSet(this.protocol);
    }

    @Override
    public String getSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    @Override
    public boolean isSchemeSpecificPartSet() {
        return this.isSet(this.schemeSpecificPart);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public Map<String, List<Object>> getQueryParameters() {
        return this.queries;
    }

    @Override
    public boolean isQuerySet() {
        return this.isSet(this.query);
    }
}

