/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.event;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.ocpsoft.rewrite.AbstractRewrite;
import org.ocpsoft.rewrite.context.Context;
import org.ocpsoft.rewrite.event.Flow;
import org.ocpsoft.rewrite.exception.RewriteException;

public abstract class BaseRewrite<IN extends ServletRequest, OUT extends ServletResponse>
extends AbstractRewrite {
    private IN request;
    private OUT response;
    protected Flow flow;
    protected String dispatchResource;
    private Context context;
    private ServletContext servletContext;

    public BaseRewrite(IN request, OUT response, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.flow = ServletRewriteFlow.UN_HANDLED;
        this.request = request;
        this.response = response;
    }

    public void abort() {
        this.flow = ServletRewriteFlow.ABORT_REQUEST;
    }

    public void proceed() {
        this.flow = ServletRewriteFlow.PROCEED;
    }

    public void handled() {
        this.flow = ServletRewriteFlow.HANDLED;
    }

    public void include(String resource) {
        this.dispatchResource = resource;
        this.flow = ServletRewriteFlow.INCLUDE;
    }

    public void forward(String resource) {
        this.dispatchResource = resource;
        this.flow = ServletRewriteFlow.FORWARD;
    }

    @Override
    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(ServletRewriteFlow flow) {
        this.flow = flow;
    }

    public String getDispatchResource() {
        return this.dispatchResource;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public IN getRequest() {
        return this.request;
    }

    public OUT getResponse() {
        return this.response;
    }

    public void setRequest(IN request) {
        this.request = request;
    }

    public void setResponse(OUT response) {
        this.response = response;
    }

    public String toString() {
        return "Rewrite [flow=" + this.flow + ", dispatchResource=" + this.dispatchResource + "]";
    }

    @Override
    public Context getRewriteContext() {
        if (this.context == null) {
            Context context = (Context)this.request.getAttribute("_com.ocpsoft.rewrite.RequestContext");
            if (context == null) {
                throw new RewriteException("RewriteContext was null. Something is seriously wrong, or you are attempting to access this event outside of the Rewrite lifecycle.");
            }
            this.context = context;
        }
        return this.context;
    }

    public static enum ServletRewriteFlow implements Flow
    {
        UN_HANDLED(null),
        HANDLED(null),
        PROCEED(UN_HANDLED),
        CONTINUE(HANDLED),
        INCLUDE(HANDLED),
        ABORT_REQUEST(HANDLED),
        FORWARD(ABORT_REQUEST),
        REDIRECT_TEMPORARY(ABORT_REQUEST),
        REDIRECT_PERMANENT(ABORT_REQUEST);

        private ServletRewriteFlow parent;

        private ServletRewriteFlow(ServletRewriteFlow flow) {
            this.parent = flow;
        }

        public boolean is(ServletRewriteFlow other) {
            if (other == null) {
                return false;
            }
            ServletRewriteFlow t = this;
            while (t != null) {
                if (other == t) {
                    return true;
                }
                t = t.parent;
            }
            return false;
        }

        public boolean contains(ServletRewriteFlow other) {
            if (other == null) {
                return false;
            }
            ServletRewriteFlow t = other;
            while (t != null) {
                if (this == t) {
                    return true;
                }
                t = t.parent;
            }
            return false;
        }

        @Override
        public boolean isHandled() {
            return this.is(HANDLED);
        }

        @Override
        public boolean is(Flow flow) {
            if (flow instanceof ServletRewriteFlow) {
                return this.is((ServletRewriteFlow)flow);
            }
            return false;
        }
    }
}

