/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.ocpsoft.rewrite.exception.RewriteException;

public class HttpAction<T extends HttpRequest> {
    private final HttpClient client;
    private final T request;
    private final HttpResponse response;
    private final HttpContext context;
    private final String baseUrl;
    private final String contextPath;

    public HttpAction(HttpClient client, HttpContext context, T request, HttpResponse response, String baseUrl, String contextPath) {
        this.client = client;
        this.request = request;
        this.context = context;
        this.response = response;
        this.baseUrl = baseUrl;
        this.contextPath = contextPath;
    }

    public String getCurrentURL() {
        HttpUriRequest currentReq = (HttpUriRequest)this.context.getAttribute("http.request");
        HttpHost currentHost = (HttpHost)this.context.getAttribute("http.target_host");
        String currentUrl = currentHost.toURI() + currentReq.getURI();
        if (currentUrl.startsWith(this.baseUrl)) {
            currentUrl = currentUrl.substring(this.baseUrl.length());
        }
        return currentUrl;
    }

    public String getCurrentContextRelativeURL() {
        if (!this.getCurrentURL().startsWith(this.getContextPath())) {
            throw new IllegalStateException("Cannot get relative URL for address outside context root [" + this.getCurrentURL() + "]");
        }
        return this.getCurrentURL().substring(this.getContextPath().length());
    }

    public String getHost() {
        HttpHost currentHost = (HttpHost)this.context.getAttribute("http.target_host");
        return currentHost.toURI();
    }

    public HttpClient getClient() {
        return this.client;
    }

    public T getRequest() {
        return this.request;
    }

    public HttpContext getContext() {
        return this.context;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public List<String> getResponseHeaderValues(String name) {
        Header[] headers;
        ArrayList<String> result = new ArrayList<String>();
        for (Header header : headers = this.getResponse().getHeaders(name)) {
            result.add(header.getValue());
        }
        return result;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getResponseContent() {
        try {
            HttpEntity entity = this.getResponse().getEntity();
            if (entity != null) {
                return HttpAction.toString(entity.getContent());
            }
        }
        catch (Exception e) {
            throw new RewriteException("Could not stringify response InputStream", (Throwable)e);
        }
        return null;
    }

    public static String toString(InputStream stream) {
        StringBuilder out = new StringBuilder();
        try {
            int read;
            char[] buffer = new char[65536];
            InputStreamReader in = new InputStreamReader(stream, "UTF-8");
            do {
                if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toString();
    }
}

