/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.mock;

import org.ocpsoft.rewrite.bind.BindingBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public class MockBinding
extends BindingBuilder<MockBinding, Object> {
    private boolean submitted;
    private boolean validated;
    private boolean converted;
    private boolean extracted;
    private Object value;
    private Object returnOnSubmit = false;

    public MockBinding() {
        this.value = new Object();
    }

    public MockBinding(Object value) {
        this.value = value;
    }

    public MockBinding(Object value, Object returnOnSubmit) {
        this.returnOnSubmit = returnOnSubmit;
        this.value = value;
    }

    public boolean validate(Rewrite event, EvaluationContext context, Object value) {
        this.validated = true;
        return true;
    }

    public Object convert(Rewrite event, EvaluationContext context, Object value) {
        this.converted = true;
        return value;
    }

    public boolean isConverted() {
        return this.converted;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public boolean isExtracted() {
        return this.extracted;
    }

    public Object submit(Rewrite event, EvaluationContext context, Object value) {
        if (value.getClass().isArray()) {
            Object[] temp = (Object[])value;
            if (temp.length > 0) {
                this.value = temp[0];
            }
        } else {
            this.value = value;
        }
        this.submitted = true;
        return this.returnOnSubmit;
    }

    public Object retrieve(Rewrite event, EvaluationContext context) {
        this.extracted = true;
        return this.value;
    }

    public boolean supportsRetrieval() {
        return true;
    }

    public boolean supportsSubmission() {
        return true;
    }

    public Object getBoundValue() {
        return this.value;
    }

    public String toString() {
        return "MockBinding [submitted=" + this.submitted + ", validated=" + this.validated + ", converted=" + this.converted + ", extracted=" + this.extracted + ", value=" + this.value + ", returnOnSubmit=" + this.returnOnSubmit + "]";
    }
}

