/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.test;

import java.io.File;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.runner.RunWith;
import org.ocpsoft.rewrite.mock.MockBinding;
import org.ocpsoft.rewrite.test.RewriteTestBase;

@RunWith(value=Arquillian.class)
public class RewriteTest
extends RewriteTestBase {
    @Deployment(testable=false)
    public static WebArchive getDeployment() {
        return RewriteTest.getDeployment("rewrite-test.war");
    }

    public static WebArchive getDeployment(String name) {
        WebArchive archive = RewriteTest.getDeploymentNoWebXml(name);
        return archive;
    }

    public static WebArchive getDeploymentNoWebXml() {
        return RewriteTest.getDeploymentNoWebXml("rewrite-test.war");
    }

    public static WebArchive getDeploymentNoWebXml(String name) {
        if (RewriteTest.isJetty() && "ROOT.war".equals(name)) {
            name = ".war";
        }
        WebArchive archive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)name)).addPackages(true, new Package[]{MockBinding.class.getPackage()})).addAsLibraries(RewriteTest.resolveDependencies("org.ocpsoft.logging:logging-api"))).addAsLibraries(new Archive[]{RewriteTest.getRewriteArchive()})).addAsLibraries(new Archive[]{RewriteTest.getContainerArchive()})).addAsLibraries(new Archive[]{RewriteTest.getCurrentArchive()});
        if (RewriteTest.isJetty()) {
            archive.add((Asset)new StringAsset("com.sun.el.ExpressionFactoryImpl"), "/WEB-INF/classes/META-INF/services/javax.el.ExpressionFactory");
            archive.addAsWebInfResource((Asset)new StringAsset("<beans/>"), "beans.xml");
            archive.addAsWebInfResource("jetty-env.xml", "jetty-env.xml");
            archive.addAsWebInfResource("jetty-log4j.xml", "log4j.xml");
        }
        if (RewriteTest.isTomcat()) {
            if (RewriteTest.isWeld()) {
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.jboss.weld:weld-core"));
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.jboss.weld.servlet:weld-servlet-core"));
                archive.addAsWebResource("tomcat-weld-context.xml", "META-INF/context.xml");
            }
            if (RewriteTest.isOWB()) {
                archive.addAsLibraries(RewriteTest.resolveDependencies("javax.enterprise:cdi-api"));
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.apache.openwebbeans:openwebbeans-impl"));
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.apache.openwebbeans:openwebbeans-web"));
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.apache.openwebbeans:openwebbeans-spi"));
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.apache.openwebbeans:openwebbeans-resource"));
                archive.addAsWebResource("tomcat-owb-context.xml", "META-INF/context.xml");
            }
            archive.addAsLibraries(RewriteTest.resolveDependencies("org.glassfish:javax.faces"));
            archive.addAsWebInfResource((Asset)new StringAsset("<beans/>"), "beans.xml");
        }
        return archive;
    }

    public static boolean isJetty() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass("org.jboss.arquillian.container.jetty.embedded_7.JettyEmbeddedContainer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isTomcat() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass("org.jboss.arquillian.container.tomcat.managed_7.TomcatManagedContainer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isWeld() {
        return "weld".equalsIgnoreCase(System.getProperty("rewrite.test.cdi"));
    }

    public static boolean isOWB() {
        return "owb".equalsIgnoreCase(System.getProperty("rewrite.test.cdi"));
    }

    protected static JavaArchive getContainerArchive() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-container-module.jar");
        if (RewriteTest.isJetty()) {
            archive.addAsManifestResource("jetty-web-fragment.xml", "web-fragment.xml");
        }
        if (RewriteTest.isTomcat()) {
            if (RewriteTest.isWeld()) {
                archive.addAsManifestResource("tomcat-weld-web-fragment.xml", "web-fragment.xml");
            }
            if (RewriteTest.isOWB()) {
                archive.addAsManifestResource("tomcat-owb-web-fragment.xml", "web-fragment.xml");
            }
        }
        return (JavaArchive)archive.addAsResource((Asset)new StringAsset("placeholder"), "README");
    }

    protected static JavaArchive getCurrentArchive() {
        File classes = new File("target/classes/org");
        File metaInf = new File("target/classes/META-INF");
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-current-module.jar");
        if (!classes.getAbsolutePath().contains("impl-servlet")) {
            if (classes.exists()) {
                archive.addAsResource(classes);
            }
            if (metaInf.exists()) {
                archive.addAsResource(metaInf);
            }
        }
        return (JavaArchive)archive.addAsResource((Asset)new StringAsset("placeholder"), "README");
    }

    protected static JavaArchive getRewriteArchive() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-servlet.jar")).addAsResource(new File("../api/target/classes/org"))).addAsResource(new File("../api-el/target/classes/org"))).addAsResource(new File("../api-el/target/classes/META-INF"))).addAsResource(new File("../impl-config/target/classes/org"))).addAsResource(new File("../api-servlet/target/classes/org"))).addAsResource(new File("../impl-servlet/target/classes/org"))).addAsResource(new File("../impl-servlet/target/classes/META-INF"));
        return archive;
    }
}

