/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.ocpsoft.rewrite.exception.RewriteException;

public class HttpAction {
    private final OkHttpClient client;
    private final Request request;
    private final Response response;
    private final String baseUrl;
    private final String contextPath;
    private String responseContent;

    public HttpAction(OkHttpClient client, Request request, Response response, String baseUrl, String contextPath) {
        this.client = client;
        this.request = request;
        this.response = response;
        this.baseUrl = baseUrl;
        this.contextPath = contextPath;
    }

    public String getCurrentURL() {
        String currentUrl = this.response.request().url().toString();
        if (currentUrl.startsWith(this.baseUrl)) {
            currentUrl = currentUrl.substring(this.baseUrl.length());
        }
        return currentUrl;
    }

    public String getCurrentContextRelativeURL() {
        if (!this.getCurrentURL().startsWith(this.getContextPath())) {
            throw new IllegalStateException("Cannot get relative URL for address outside context root [" + this.getCurrentURL() + "]");
        }
        return this.getCurrentURL().substring(this.getContextPath().length());
    }

    public String getHost() {
        return this.request.url().host();
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public List<String> getResponseHeaderValues(String name) {
        return this.response.headers(name);
    }

    public int getStatusCode() {
        return this.response.code();
    }

    public String getResponseContent() {
        if (this.responseContent == null) {
            try {
                ResponseBody entity = this.getResponse().body();
                if (entity != null) {
                    this.responseContent = entity.string();
                }
            }
            catch (Exception e) {
                throw new RewriteException("Could not stringify response InputStream", (Throwable)e);
            }
        }
        return this.responseContent;
    }

    public static String toString(InputStream stream) {
        StringBuilder out = new StringBuilder();
        try {
            int read;
            char[] buffer = new char[65536];
            InputStreamReader in = new InputStreamReader(stream, "UTF-8");
            do {
                if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toString();
    }
}

