/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.test;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.assertj.core.api.Fail;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.ocpsoft.rewrite.test.HtmlAction;
import org.ocpsoft.rewrite.test.HttpAction;

public abstract class RewriteITBase {
    protected final OkHttpClient client;
    @ArquillianResource
    URL baseUrl;

    protected RewriteITBase() {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(System.out::println);
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.client = new OkHttpClient.Builder().addInterceptor((Interceptor)loggingInterceptor).build();
    }

    protected static File[] resolveDependencies(String coords) {
        return ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve(coords)).withTransitivity()).asFile();
    }

    protected static File resolveDependency(String coords) {
        return RewriteITBase.resolveDependencies(coords)[0];
    }

    protected HttpAction get(String path) throws Exception {
        return this.get(this.client, path);
    }

    protected HttpAction get(OkHttpClient client, String path) throws Exception {
        return this.get(client, path, Headers.of((String[])new String[0]));
    }

    protected HttpAction get(OkHttpClient client, String path, Headers headers) throws Exception {
        Request request = new Request.Builder().get().url(this.getBaseURL() + this.getContextPath() + path).headers(headers).build();
        Response response = client.newCall(request).execute();
        return new HttpAction(client, request, response, this.getBaseURL(), this.getContextPath());
    }

    protected HttpAction head(String path) {
        try {
            Request request = new Request.Builder().head().url(this.getBaseURL() + this.getContextPath() + path).build();
            Response response = this.client.newCall(request).execute();
            return new HttpAction(this.client, request, response, this.getBaseURL(), this.getContextPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getBaseURL() {
        return this.baseUrl.getProtocol() + "://" + this.baseUrl.getHost() + (String)(this.baseUrl.getPort() == -1 ? "" : ":" + this.baseUrl.getPort());
    }

    protected String getContextPath() {
        String contextPath = this.baseUrl.getPath();
        if (!"/".equals(contextPath)) {
            contextPath = contextPath.replaceAll("^(.*)/$", "$1").replaceAll("ROOT$", "");
        }
        return contextPath;
    }

    protected HtmlAction getWebClient(String path) throws FailingHttpStatusCodeException, IOException {
        try {
            WebClient client = new WebClient();
            return new HtmlAction(client, (HtmlPage)client.getPage(this.getBaseURL() + this.getContextPath() + path));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void assertContains(String text, String s) {
        if (text == null || s == null || !text.contains(s)) {
            Fail.fail((String)("Could not find [" + s + "] in text: " + text));
        }
    }
}

