/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.test;

import java.io.File;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.runner.RunWith;
import org.ocpsoft.rewrite.mock.MockBinding;
import org.ocpsoft.rewrite.test.RewriteTestBase;

@RunWith(value=Arquillian.class)
public class RewriteTest
extends RewriteTestBase {
    @Deployment(testable=false)
    public static WebArchive getDeployment() {
        return RewriteTest.getDeployment("rewrite-test.war");
    }

    public static WebArchive getDeployment(String name) {
        WebArchive archive = RewriteTest.getDeploymentNoWebXml(name);
        return archive;
    }

    public static WebArchive getDeploymentWithCDI() {
        WebArchive archive = RewriteTest.getDeployment();
        archive.addAsWebInfResource((Asset)new StringAsset("<beans/>"), "beans.xml");
        return archive;
    }

    public static WebArchive getDeploymentWithFacesAndCDI() {
        WebArchive archive = RewriteTest.getDeployment();
        archive.addAsWebInfResource((Asset)new StringAsset("<beans/>"), "beans.xml");
        archive.addAsWebInfResource((Asset)new StringAsset("<faces-config version=\"2.0\"/>"), "faces-config.xml");
        return archive;
    }

    public static WebArchive getDeploymentNoWebXml() {
        return RewriteTest.getDeploymentNoWebXml("rewrite-test.war");
    }

    public static WebArchive getDeploymentNoWebXml(String name) {
        if (RewriteTest.isJetty() && "ROOT.war".equals(name)) {
            name = ".war";
        }
        WebArchive archive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)name)).addPackages(true, new Package[]{MockBinding.class.getPackage()})).addAsLibraries(RewriteTest.resolveDependencies("org.ocpsoft.logging:logging-api"))).addAsLibraries(new Archive[]{RewriteTest.getRewriteArchive()})).addAsLibraries(new Archive[]{RewriteTest.getRewriteConfigArchive()})).addAsLibraries(new Archive[]{RewriteTest.getRewriteAnnotationsArchive()})).addAsLibraries(new Archive[]{RewriteTest.getContainerArchive()})).addAsLibraries(new Archive[]{RewriteTest.getCurrentArchive()});
        if (RewriteTest.isJetty()) {
            archive.add((Asset)new StringAsset("com.sun.el.ExpressionFactoryImpl"), "/WEB-INF/classes/META-INF/services/javax.el.ExpressionFactory");
            archive.addAsWebInfResource("jetty-env.xml", "jetty-env.xml");
            archive.addAsWebInfResource("jetty-log4j.xml", "log4j.xml");
        }
        if (RewriteTest.isTomcat()) {
            if (RewriteTest.isWeld()) {
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.jboss.weld:weld-core:1.1.9.Final"));
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.jboss.weld.servlet:weld-servlet-core:1.1.9.Final"));
                archive.addAsWebResource("tomcat-weld-context.xml", "META-INF/context.xml");
            }
            if (RewriteTest.isOWB()) {
                archive.addAsLibraries(RewriteTest.resolveDependencies("javax.enterprise:cdi-api:1.0-SP4"));
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.apache.openwebbeans:openwebbeans-impl:1.1.5"));
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.apache.openwebbeans:openwebbeans-web:1.1.5"));
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.apache.openwebbeans:openwebbeans-spi:1.1.5"));
                archive.addAsLibraries(RewriteTest.resolveDependencies("org.apache.openwebbeans:openwebbeans-resource:1.1.5"));
                archive.addAsWebResource("tomcat-owb-context.xml", "META-INF/context.xml");
            }
            archive.addAsLibraries(RewriteTest.resolveDependencies("org.glassfish:javax.faces:2.1.13"));
            archive.addAsLibraries(RewriteTest.resolveDependencies("javax.servlet:jstl:1.2"));
        }
        return archive;
    }

    public static boolean isJetty() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass("org.jboss.arquillian.container.jetty.embedded_7.JettyEmbeddedContainer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isTomcat() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass("org.jboss.arquillian.container.tomcat.managed_7.TomcatManagedContainer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isWeld() {
        return "weld".equalsIgnoreCase(System.getProperty("rewrite.test.cdi"));
    }

    public static boolean isOWB() {
        return "owb".equalsIgnoreCase(System.getProperty("rewrite.test.cdi"));
    }

    protected static JavaArchive getContainerArchive() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-container-module.jar");
        if (RewriteTest.isJetty()) {
            archive.addAsManifestResource("jetty-web-fragment.xml", "web-fragment.xml");
        }
        if (RewriteTest.isTomcat()) {
            if (RewriteTest.isWeld()) {
                archive.addAsManifestResource("tomcat-weld-web-fragment.xml", "web-fragment.xml");
            }
            if (RewriteTest.isOWB()) {
                archive.addAsManifestResource("tomcat-owb-web-fragment.xml", "web-fragment.xml");
            }
        }
        return (JavaArchive)archive.addAsResource((Asset)new StringAsset("placeholder"), "README");
    }

    protected static JavaArchive getCurrentArchive() {
        File org = new File("target/classes/org");
        File metaInf = new File("target/classes/META-INF");
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-current-module.jar");
        if (!org.getAbsolutePath().contains("impl-servlet") && !org.getAbsolutePath().contains("config-servlet")) {
            if (org.exists()) {
                archive.addAsResource(org);
            }
            if (metaInf.exists()) {
                archive.addAsResource(metaInf);
            }
        }
        return (JavaArchive)archive.addAsResource((Asset)new StringAsset("placeholder"), "README");
    }

    protected static JavaArchive getRewriteArchive() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-servlet.jar")).addAsResource(new File("../api/target/classes/org"))).addAsResource(new File("../api-el/target/classes/org"))).addAsResource(new File("../api-el/target/classes/META-INF"))).addAsResource(new File("../impl/target/classes/org"))).addAsResource(new File("../impl/target/classes/META-INF"))).addAsResource(new File("../addressbuilder/target/classes/org"))).addAsResource(new File("../api-servlet/target/classes/org"))).addAsServiceProvider("org.ocpsoft.rewrite.servlet.spi.ServletRegistrationProvider", new String[]{"org.ocpsoft.rewrite.servlet.impl.Servlet3ServletRegistrationProvider", "org.ocpsoft.rewrite.servlet.impl.WebXmlServletRegistrationProvider"})).addAsServiceProvider("org.ocpsoft.rewrite.servlet.spi.DispatcherTypeProvider", new String[]{"org.ocpsoft.rewrite.servlet.impl.Servlet3DispatcherTypeProvider", "org.ocpsoft.rewrite.servlet.impl.Servlet25DispatcherTypeProvider"})).addAsResource(new File("../impl-servlet-2.5/target/classes/org"))).addAsResource(new File("../impl-servlet-2.5/target/classes/META-INF"))).addAsResource(new File("../impl-servlet-3.0/target/classes/org"))).addAsResource(new File("../impl-servlet-3.0/target/classes/META-INF"));
        File implClasses = new File("../impl-servlet/target/classes/org");
        if (implClasses.exists()) {
            ((JavaArchive)archive.addAsResource(implClasses)).addAsResource(new File("../impl-servlet/target/classes/META-INF"));
        }
        return archive;
    }

    protected static JavaArchive getRewriteAnnotationsArchive() {
        File classes = new File("../config-annotations/target/classes/org");
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-annotations.jar");
        if (classes.exists()) {
            ((JavaArchive)((JavaArchive)archive.addAsResource(new File("../annotations-api/target/classes/org"))).addAsResource(new File("../annotations-impl/target/classes/org"))).addAsResource(new File("../annotations-impl/target/classes/META-INF"));
            if (!new File("target/classes").getAbsolutePath().contains("config-annotations")) {
                ((JavaArchive)archive.addAsResource(new File("../config-annotations/target/classes/org"))).addAsResource(new File("../config-annotations/target/classes/META-INF"));
            }
        }
        return (JavaArchive)archive.addAsResource((Asset)new StringAsset("placeholder"), "README");
    }

    protected static JavaArchive getRewriteCDIArchive() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-integration-cdi.jar")).addAsResource(new File("../integration-cdi/target/classes/org"))).addAsResource(new File("../integration-cdi/target/classes/META-INF"));
        return archive;
    }

    protected static JavaArchive getRewriteConfigArchive() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-config-servlet.jar")).addAsResource(new File("../config-servlet/target/classes/org"))).addAsResource(new File("../config-servlet/target/classes/META-INF"));
        return archive;
    }

    protected static JavaArchive getRewriteFacesArchive() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-integration-faces.jar")).addAsResource(new File("../integration-faces/target/classes/org"))).addAsResource(new File("../integration-faces/target/classes/META-INF"));
        return archive;
    }
}

