/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.test;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.junit.Assert;
import org.ocpsoft.rewrite.test.HtmlAction;
import org.ocpsoft.rewrite.test.HttpAction;

public abstract class RewriteTestBase {
    @ArquillianResource
    URL baseUrl;

    protected static File[] resolveDependencies(String coords) {
        return ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve(coords)).withTransitivity()).asFile();
    }

    protected static File resolveDependency(String coords) {
        return RewriteTestBase.resolveDependencies(coords)[0];
    }

    protected HttpAction<HttpGet> get(String path) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        return this.get((HttpClient)client, path);
    }

    protected HttpAction<HttpGet> get(HttpClient client, String path) throws Exception {
        return this.get(client, path, new Header[0]);
    }

    protected HttpAction<HttpGet> get(HttpClient client, String path, Header ... headers) throws Exception {
        HttpGet request = new HttpGet(this.getBaseURL() + this.getContextPath() + path);
        if (headers != null && headers.length > 0) {
            request.setHeaders(headers);
        }
        BasicHttpContext context = new BasicHttpContext();
        HttpResponse response = client.execute((HttpUriRequest)request, (HttpContext)context);
        return new HttpAction<HttpGet>(client, (HttpContext)context, request, response, this.getBaseURL(), this.getContextPath());
    }

    protected HttpAction<HttpHead> head(String path) {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpHead request = new HttpHead(this.getBaseURL() + this.getContextPath() + path);
            BasicHttpContext context = new BasicHttpContext();
            HttpResponse response = client.execute((HttpUriRequest)request, (HttpContext)context);
            return new HttpAction<HttpHead>((HttpClient)client, (HttpContext)context, request, response, this.getBaseURL(), this.getContextPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getBaseURL() {
        return this.baseUrl.getProtocol() + "://" + this.baseUrl.getHost() + (this.baseUrl.getPort() == -1 ? "" : ":" + this.baseUrl.getPort());
    }

    protected String getContextPath() {
        String contextPath = this.baseUrl.getPath();
        if (!"/".equals(contextPath)) {
            contextPath = contextPath.replaceAll("^(.*)/$", "$1").replaceAll("ROOT$", "");
        }
        return contextPath;
    }

    protected HtmlAction getWebClient(String path) throws FailingHttpStatusCodeException, IOException {
        try {
            WebClient client = new WebClient();
            return new HtmlAction(client, (HtmlPage)client.getPage(this.getBaseURL() + this.getContextPath() + path));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void assertContains(String text, String s) {
        if (text == null || s == null || !text.contains(s)) {
            Assert.fail((String)("Could not find [" + s + "] in text: " + text));
        }
    }
}

