/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.test;

import java.io.File;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.runner.RunWith;
import org.ocpsoft.rewrite.mock.MockBinding;
import org.ocpsoft.rewrite.test.RewriteITBase;

@RunWith(value=Arquillian.class)
public class RewriteIT
extends RewriteITBase {
    public static WebArchive getDeployment() {
        return RewriteIT.getDeployment("rewrite-test.war");
    }

    public static WebArchive getDeployment(String name) {
        WebArchive archive = RewriteIT.getDeploymentNoWebXml(name);
        return archive;
    }

    public static WebArchive getDeploymentWithCDI() {
        WebArchive archive = RewriteIT.getDeployment();
        archive.addAsWebInfResource((Asset)new StringAsset("<beans/>"), "beans.xml");
        return archive;
    }

    public static WebArchive getDeploymentWithFacesAndCDI() {
        WebArchive archive = RewriteIT.getDeployment();
        archive.addAsWebInfResource((Asset)new StringAsset("<beans/>"), "beans.xml");
        archive.addAsWebInfResource((Asset)new StringAsset("<faces-config version=\"2.0\"/>"), "faces-config.xml");
        return archive;
    }

    public static WebArchive getDeploymentNoWebXml() {
        return RewriteIT.getDeploymentNoWebXml("rewrite-test.war");
    }

    public static WebArchive getDeploymentNoWebXml(String name) {
        if (RewriteIT.isJetty() && "ROOT.war".equals(name)) {
            name = ".war";
        }
        WebArchive archive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)name)).addPackages(true, new Package[]{MockBinding.class.getPackage()})).addAsLibraries(RewriteIT.resolveDependencies("org.ocpsoft.logging:logging-api"))).addAsLibraries(new Archive[]{RewriteIT.getRewriteArchive()})).addAsLibraries(new Archive[]{RewriteIT.getRewriteConfigArchive()})).addAsLibraries(new Archive[]{RewriteIT.getRewriteAnnotationsArchive()})).addAsLibraries(new Archive[]{RewriteIT.getContainerArchive()})).addAsLibraries(new Archive[]{RewriteIT.getCurrentArchive()});
        if (RewriteIT.isJetty()) {
            archive.add((Asset)new StringAsset("com.sun.el.ExpressionFactoryImpl"), "/WEB-INF/classes/META-INF/services/javax.el.ExpressionFactory");
            archive.addAsWebInfResource("jetty-env.xml", "jetty-env.xml");
            archive.addAsWebInfResource("jetty-log4j.xml", "log4j.xml");
        }
        if (RewriteIT.isTomcat()) {
            archive.addAsLibraries(RewriteIT.resolveDependencies("jakarta.enterprise:jakarta.enterprise.cdi-api:2.0.2"));
            archive.addAsLibraries(RewriteIT.resolveDependencies("jakarta.inject:jakarta.inject-api:1.0.5"));
            if (RewriteIT.isWeld()) {
                archive.addAsLibraries(RewriteIT.resolveDependencies("org.jboss.weld:weld-core:2.4.7.Final"));
                archive.addAsLibraries(RewriteIT.resolveDependencies("org.jboss.weld.servlet:weld-servlet-core:2.4.7.Final"));
                archive.addAsWebResource("tomcat-weld-context.xml", "META-INF/context.xml");
            } else {
                archive.addAsWebResource("tomcat-context.xml", "META-INF/context.xml");
            }
            if (RewriteIT.isOWB()) {
                archive.addAsLibraries(RewriteIT.resolveDependencies("org.apache.openwebbeans:openwebbeans-impl:2.0.7"));
                archive.addAsLibraries(RewriteIT.resolveDependencies("org.apache.openwebbeans:openwebbeans-web:2.0.7"));
                archive.addAsLibraries(RewriteIT.resolveDependencies("org.apache.openwebbeans:openwebbeans-spi:2.0.7"));
                archive.addAsLibraries(RewriteIT.resolveDependencies("org.apache.openwebbeans:openwebbeans-resource:2.0.7"));
                archive.addAsWebResource("tomcat-owb-context.xml", "META-INF/context.xml");
            }
        }
        return archive;
    }

    public static boolean isJetty() {
        return RewriteIT.isClassPresent("org.jboss.arquillian.container.jetty.embedded_7.JettyEmbeddedContainer");
    }

    public static boolean isTomcat() {
        return RewriteIT.isClassPresent("org.jboss.arquillian.container.tomcat.managed.Tomcat8ManagedContainer") || RewriteIT.isClassPresent("org.jboss.arquillian.container.tomcat.embedded.Tomcat8EmbeddedContainer");
    }

    private static boolean isClassPresent(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isWeld() {
        return "weld".equalsIgnoreCase(System.getProperty("rewrite.test.cdi"));
    }

    public static boolean isOWB() {
        return "owb".equalsIgnoreCase(System.getProperty("rewrite.test.cdi"));
    }

    protected static JavaArchive getContainerArchive() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-container-module.jar");
        if (RewriteIT.isJetty()) {
            archive.addAsManifestResource("jetty-web-fragment.xml", "web-fragment.xml");
        }
        if (RewriteIT.isTomcat()) {
            if (RewriteIT.isWeld()) {
                archive.addAsManifestResource("tomcat-weld-web-fragment.xml", "web-fragment.xml");
            }
            if (RewriteIT.isOWB()) {
                archive.addAsManifestResource("tomcat-owb-web-fragment.xml", "web-fragment.xml");
            }
        }
        return (JavaArchive)archive.addAsResource((Asset)new StringAsset("placeholder"), "README");
    }

    protected static JavaArchive getCurrentArchive() {
        File org = new File("target/classes/org");
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-current-module.jar");
        if (!org.getAbsolutePath().contains("impl-servlet") && !org.getAbsolutePath().contains("config-servlet")) {
            RewriteIT.addAsResource(archive, org);
            RewriteIT.addAsResource(archive, new File("target/classes/META-INF"));
        }
        return (JavaArchive)archive.addAsResource((Asset)new StringAsset("placeholder"), "README");
    }

    protected static JavaArchive getRewriteArchive() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-servlet.jar");
        RewriteIT.addAsResource(archive, new File("../api/target/classes/org"));
        RewriteIT.addAsResource(archive, new File("../api-el/target/classes/org"));
        RewriteIT.addAsResource(archive, new File("../api-el/target/classes/META-INF"));
        RewriteIT.addAsResource(archive, new File("../impl/target/classes/org"));
        RewriteIT.addAsResource(archive, new File("../impl/target/classes/META-INF"));
        RewriteIT.addAsResource(archive, new File("../addressbuilder/target/classes/org"));
        RewriteIT.addAsResource(archive, new File("../api-servlet/target/classes/org"));
        RewriteIT.addAsResource(archive, new File("../impl-servlet/target/classes/org"));
        RewriteIT.addAsResource(archive, new File("../impl-servlet/target/classes/META-INF"));
        return archive;
    }

    private static void addAsResource(JavaArchive archive, File file) {
        if (file != null && file.exists()) {
            archive.addAsResource(file);
        }
    }

    protected static JavaArchive getRewriteAnnotationsArchive() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-annotations2.jar");
        RewriteIT.addAsResource(archive, new File("../annotations-api/target/classes/org"));
        RewriteIT.addAsResource(archive, new File("../annotations-impl/target/classes/org"));
        RewriteIT.addAsResource(archive, new File("../annotations-impl/target/classes/META-INF"));
        if (!new File("target/classes").getAbsolutePath().contains("config-annotations")) {
            RewriteIT.addAsResource(archive, new File("../config-annotations/target/classes/org"));
            RewriteIT.addAsResource(archive, new File("../config-annotations/target/classes/META-INF"));
        }
        return (JavaArchive)archive.addAsResource((Asset)new StringAsset("placeholder"), "README");
    }

    protected static JavaArchive getRewriteCDIArchive() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-integration-cdi.jar");
        RewriteIT.addAsResource(archive, new File("../integration-cdi/target/classes/org"));
        RewriteIT.addAsResource(archive, new File("../integration-cdi/target/classes/META-INF"));
        return archive;
    }

    protected static JavaArchive getRewriteConfigArchive() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-config-servlet.jar");
        RewriteIT.addAsResource(archive, new File("../config-servlet/target/classes/org"));
        RewriteIT.addAsResource(archive, new File("../config-servlet/target/classes/META-INF"));
        return archive;
    }

    protected static JavaArchive getRewriteFacesArchive() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"rewrite-integration-faces.jar");
        RewriteIT.addAsResource(archive, new File("../integration-faces/target/classes/org"));
        RewriteIT.addAsResource(archive, new File("../integration-faces/target/classes/META-INF"));
        return archive;
    }
}

