/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform.markup.impl;

import jakarta.servlet.ServletContext;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.CompatVersion;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.transform.StringTransformer;

public abstract class JRubyTransformer<T extends JRubyTransformer<T>>
extends StringTransformer {
    static final String CONTAINER_STORE_KEY = JRubyTransformer.class.getName() + "_CONTAINER_INSTANCE";
    private RubyInstanceConfig.CompileMode compileMode = RubyInstanceConfig.CompileMode.JIT;
    private CompatVersion compatVersion = CompatVersion.RUBY2_0;

    public abstract List<String> getLoadPaths();

    public abstract Object runScript(ScriptingContainer var1);

    public abstract T self();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String transform(HttpServletRewrite event, String input) {
        ScriptingContainer container = this.getContainer(event.getServletContext());
        try {
            Object result = null;
            container.put("input", (Object)input);
            result = this.runScript(container);
            String string = result != null ? result.toString() : null;
            return string;
        }
        finally {
            if (container != null) {
                container.clear();
            }
        }
    }

    private ScriptingContainer getContainer(ServletContext context) {
        ScriptingContainer cachedContainer;
        ConcurrentHashMap<Class<T>, ScriptingContainer> storage = (ConcurrentHashMap<Class<T>, ScriptingContainer>)context.getAttribute(CONTAINER_STORE_KEY);
        if (storage == null) {
            storage = new ConcurrentHashMap<Class<T>, ScriptingContainer>();
            context.setAttribute(CONTAINER_STORE_KEY, storage);
        }
        if ((cachedContainer = (ScriptingContainer)storage.get(this.getTransformerType())) == null) {
            List<String> loadPaths;
            cachedContainer = new ScriptingContainer(LocalContextScope.CONCURRENT, LocalVariableBehavior.TRANSIENT);
            cachedContainer.setRunRubyInProcess(false);
            storage.put(this.getTransformerType(), cachedContainer);
            if (this.compileMode != null) {
                cachedContainer.setCompileMode(this.compileMode);
            }
            if (this.compatVersion != null) {
                cachedContainer.setCompatVersion(this.compatVersion);
            }
            if ((loadPaths = this.getLoadPaths()) != null && !loadPaths.isEmpty()) {
                cachedContainer.getLoadPaths().addAll(loadPaths);
            }
            this.prepareContainer(cachedContainer);
        }
        return cachedContainer;
    }

    protected abstract Class<T> getTransformerType();

    protected abstract void prepareContainer(ScriptingContainer var1);

    public T compileMode(RubyInstanceConfig.CompileMode compileMode) {
        this.compileMode = compileMode;
        return this.self();
    }

    public T compatVersion(CompatVersion compatVersion) {
        this.compatVersion = compatVersion;
        return this.self();
    }
}

