/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform.markup;

import java.util.Arrays;
import java.util.List;
import org.jruby.embed.ScriptingContainer;
import org.ocpsoft.rewrite.transform.markup.HtmlDocumentBuilder;
import org.ocpsoft.rewrite.transform.markup.JRubyTransformer;

public class Markdown
extends JRubyTransformer<Markdown> {
    private static final String SCRIPT = "require 'maruku'\nMaruku.new(input).to_html";
    private final boolean fullDocument;
    private final HtmlDocumentBuilder documentBuilder = new HtmlDocumentBuilder();

    public static Markdown fullDocument() {
        return new Markdown(true);
    }

    public static Markdown partialDocument() {
        return new Markdown(false);
    }

    private Markdown(boolean fullDocument) {
        this.fullDocument = fullDocument;
    }

    public Markdown withTitle(String title) {
        this.documentBuilder.withTitle(title);
        return this;
    }

    public Markdown addStylesheet(String url) {
        this.documentBuilder.addStylesheet(url);
        return this;
    }

    @Override
    public List<String> getLoadPaths() {
        return Arrays.asList("ruby/maruku/lib");
    }

    @Override
    public Object runScript(ScriptingContainer container) {
        Object fragment = container.runScriptlet(SCRIPT);
        if (fragment != null) {
            if (this.fullDocument) {
                return this.documentBuilder.build(fragment.toString());
            }
            return fragment.toString();
        }
        return null;
    }

    @Override
    public Markdown self() {
        return this;
    }
}

