/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform.markup;

import java.util.List;
import org.jruby.CompatVersion;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.transform.StringTransformer;

abstract class JRubyTransformer<T>
extends StringTransformer {
    private RubyInstanceConfig.CompileMode compileMode = null;
    private CompatVersion compatVersion = null;
    ScriptingContainer container = new ScriptingContainer(LocalContextScope.THREADSAFE, LocalVariableBehavior.TRANSIENT);

    public abstract List<String> getLoadPaths();

    public abstract Object runScript(ScriptingContainer var1);

    public abstract T self();

    public JRubyTransformer() {
        List<String> loadPaths;
        if (this.compileMode != null) {
            this.container.setCompileMode(this.compileMode);
        }
        if (this.compatVersion != null) {
            this.container.setCompatVersion(this.compatVersion);
        }
        if ((loadPaths = this.getLoadPaths()) != null && !loadPaths.isEmpty()) {
            this.container.setLoadPaths(loadPaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String transform(HttpServletRewrite event, String input) {
        try {
            Object result = null;
            Object object = this.container;
            synchronized (object) {
                this.container.put("input", (Object)input);
                this.prepareContainer(this.container);
                result = this.runScript(this.container);
            }
            object = result != null ? result.toString() : null;
            return object;
        }
        finally {
            if (this.container != null) {
                this.container.terminate();
            }
        }
    }

    protected void prepareContainer(ScriptingContainer container) {
    }

    public T compileMode(RubyInstanceConfig.CompileMode compileMode) {
        this.compileMode = compileMode;
        return this.self();
    }

    public T compatVersion(CompatVersion compatVersion) {
        this.compatVersion = compatVersion;
        return this.self();
    }
}

