/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform.markup;

import java.util.ArrayList;
import java.util.List;
import org.ocpsoft.common.util.Strings;

class HtmlDocumentBuilder {
    private String title;
    private final List<String> stylesheets = new ArrayList<String>();
    private final List<String> headerInjections = new ArrayList<String>();

    HtmlDocumentBuilder() {
    }

    public HtmlDocumentBuilder addStylesheet(String url) {
        this.stylesheets.add(url);
        return this;
    }

    public HtmlDocumentBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public HtmlDocumentBuilder addHeaderInjection(String element) {
        this.headerInjections.add(element);
        return this;
    }

    public String build(String body) {
        StringBuilder result = new StringBuilder();
        result.append("<!DOCTYPE html>\n");
        result.append("<html>\n");
        result.append("<head>\n");
        if (!Strings.isNullOrEmpty((String)this.title)) {
            result.append("<title>").append(this.title.trim()).append("</title>\n");
        }
        for (String stylesheet : this.stylesheets) {
            result.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            result.append(stylesheet);
            result.append("\">\n");
        }
        for (String headerInjection : this.headerInjections) {
            result.append(headerInjection);
            result.append("\n");
        }
        result.append("</head>\n");
        result.append("<body>\n");
        if (!Strings.isNullOrEmpty((String)body)) {
            result.append(body).append("\n");
        }
        result.append("</body>\n");
        result.append("</html>\n");
        return result.toString();
    }
}

