/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform.minify;

import de.larsgrefer.sass.embedded.SassCompiler;
import de.larsgrefer.sass.embedded.SassCompilerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.transform.Transformer;
import org.ocpsoft.rewrite.transform.minify.Minify;
import sass.embedded_protocol.EmbeddedSass;

public class CssMinify
extends Minify
implements Transformer {
    CssMinify() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(HttpServletRewrite event, InputStream input, OutputStream output) throws IOException {
        String css = new String(input.readAllBytes(), StandardCharsets.UTF_8);
        try (SassCompiler sassCompiler = SassCompilerFactory.bundled();){
            sassCompiler.setOutputStyle(EmbeddedSass.OutputStyle.COMPRESSED);
            EmbeddedSass.OutboundMessage.CompileResponse.CompileSuccess compileSuccess = sassCompiler.compileCssString(css);
            compileSuccess.getCssBytes().writeTo(output);
        }
        catch (Exception e) {
            event.getServletContext().log("Failed to minify css", (Throwable)e);
            output.write(css.getBytes(StandardCharsets.UTF_8));
        }
        finally {
            output.flush();
        }
    }
}

