/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform.minify.shade.org.mozilla.javascript;

import org.ocpsoft.rewrite.transform.minify.shade.org.mozilla.javascript.BaseFunction;
import org.ocpsoft.rewrite.transform.minify.shade.org.mozilla.javascript.Context;
import org.ocpsoft.rewrite.transform.minify.shade.org.mozilla.javascript.Decompiler;
import org.ocpsoft.rewrite.transform.minify.shade.org.mozilla.javascript.NativeCall;
import org.ocpsoft.rewrite.transform.minify.shade.org.mozilla.javascript.ScriptRuntime;
import org.ocpsoft.rewrite.transform.minify.shade.org.mozilla.javascript.Scriptable;
import org.ocpsoft.rewrite.transform.minify.shade.org.mozilla.javascript.UintMap;
import org.ocpsoft.rewrite.transform.minify.shade.org.mozilla.javascript.debug.DebuggableScript;

public abstract class NativeFunction
extends BaseFunction {
    public final void initScriptFunction(Context cx, Scriptable scope) {
        ScriptRuntime.setFunctionProtoAndParent(this, scope);
    }

    final String decompile(int indent, int flags) {
        String encodedSource = this.getEncodedSource();
        if (encodedSource == null) {
            return super.decompile(indent, flags);
        }
        UintMap properties = new UintMap(1);
        properties.put(1, indent);
        return Decompiler.decompile(encodedSource, flags, properties);
    }

    public int getLength() {
        int paramCount = this.getParamCount();
        if (this.getLanguageVersion() != 120) {
            return paramCount;
        }
        Context cx = Context.getContext();
        NativeCall activation = ScriptRuntime.findFunctionActivation(cx, this);
        if (activation == null) {
            return paramCount;
        }
        return activation.originalArgs.length;
    }

    public int getArity() {
        return this.getParamCount();
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getEncodedSource() {
        return null;
    }

    public DebuggableScript getDebuggableView() {
        return null;
    }

    protected abstract int getLanguageVersion();

    protected abstract int getParamCount();

    protected abstract int getParamAndVarCount();

    protected abstract String getParamOrVarName(int var1);

    protected abstract boolean getParamOrVarConst(int var1);
}

