/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.common.util.Streams;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.transform.Pipeline;
import org.ocpsoft.rewrite.transform.Transformer;
import org.ocpsoft.rewrite.transform.cache.CacheKeyStrategy;
import org.ocpsoft.rewrite.transform.cache.CachedTransformation;
import org.ocpsoft.rewrite.transform.cache.DefaultTransformationCache;
import org.ocpsoft.rewrite.transform.cache.RequestPathCacheKeyStrategy;
import org.ocpsoft.rewrite.transform.cache.TransformationCache;
import org.ocpsoft.rewrite.transform.resolve.ResourceResolver;
import org.ocpsoft.rewrite.transform.resolve.WebResourceResolver;
import org.ocpsoft.rewrite.transform.resource.Resource;

public class Transform
extends HttpOperation {
    private static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private final Logger log = Logger.getLogger(Transform.class);
    private ResourceResolver resolver = WebResourceResolver.identity();
    private Pipeline pipeline = new Pipeline();
    private TransformationCache cache = new DefaultTransformationCache();
    private CacheKeyStrategy cacheKeyFactory = new RequestPathCacheKeyStrategy();

    public static Transform with(Class<? extends Transformer> transformerType) {
        return new Transform().apply(transformerType);
    }

    public Transform apply(Class<? extends Transformer> transformerType) {
        try {
            return this.apply(transformerType.newInstance());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Transform apply(Class<? extends Transformer> first, Class<? extends Transformer> second, Class<? extends Transformer> third) {
        this.apply(first);
        this.apply(second);
        this.apply(third);
        return this;
    }

    public Transform apply(Class<? extends Transformer> first, Class<? extends Transformer> second) {
        this.apply(first);
        this.apply(second);
        return this;
    }

    public Transform apply(Class<? extends Transformer> ... transformerTypes) {
        for (Class<? extends Transformer> transformerType : transformerTypes) {
            this.apply(transformerType);
        }
        return this;
    }

    public Transform apply(Transformer ... transformers) {
        for (Transformer transformer : transformers) {
            this.pipeline.add(transformer);
        }
        return this;
    }

    public Transform cacheWith(TransformationCache cache) {
        this.cache = cache;
        return this;
    }

    public Transform resolvedBy(ResourceResolver resourceResolver) {
        this.resolver = resourceResolver;
        return this;
    }

    public Transform cacheKeyStrategy(CacheKeyStrategy cacheKeyFactory) {
        this.cacheKeyFactory = cacheKeyFactory;
        return this;
    }

    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            HttpInboundServletRewrite inboundRewrite = (HttpInboundServletRewrite)event;
            HttpServletResponse response = (HttpServletResponse)inboundRewrite.getResponse();
            try {
                Resource resource = this.resolver.getResource((Rewrite)event, context);
                if (resource != null) {
                    if (this.clientHasAlreadyTheLatestVersion(inboundRewrite, resource)) {
                        inboundRewrite.sendStatusCode(304);
                    } else {
                        Serializable key = this.cacheKeyFactory.create((Rewrite)inboundRewrite);
                        CachedTransformation cacheEntry = this.cache.get(key);
                        byte[] result = null;
                        if (cacheEntry != null && cacheEntry.getTimestamp() >= resource.getLastModified()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Found cached transformation for: {}", (Object)key);
                            }
                            result = cacheEntry.getData();
                        } else {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("No cached transformation found. Starting transformation process...");
                            }
                            long start = System.currentTimeMillis();
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            this.pipeline.transform(resource.getInputStream(), bos);
                            result = bos.toByteArray();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Transformation finished in: {}ms", (Object)(System.currentTimeMillis() - start));
                            }
                            this.cache.put(key, new CachedTransformation(result, resource.getLastModified()));
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Writing {} bytes back to the client.", (Object)result.length);
                        }
                        if (resource.getLastModified() > 0L) {
                            response.setDateHeader("Last-Modified", resource.getLastModified() + 1000L);
                        }
                        Streams.copy((InputStream)new ByteArrayInputStream(result), (OutputStream)response.getOutputStream());
                        response.flushBuffer();
                    }
                    inboundRewrite.abort();
                }
            }
            catch (IOException e) {
                this.log.error("Failed to render resource", (Throwable)e);
            }
        }
    }

    private boolean clientHasAlreadyTheLatestVersion(HttpInboundServletRewrite rewrite, Resource resource) {
        if (resource.getLastModified() > 0L) {
            long ifModifiedSince = 0L;
            String headerValue = ((HttpServletRequest)rewrite.getRequest()).getHeader("If-Modified-Since");
            if (headerValue != null && headerValue.trim().length() > 0) {
                try {
                    ifModifiedSince = new SimpleDateFormat(PATTERN_RFC1123, Locale.ENGLISH).parse(headerValue).getTime();
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            if (ifModifiedSince > 0L && ifModifiedSince > resource.getLastModified()) {
                return true;
            }
        }
        return false;
    }
}

