/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform.resolve;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.parse.CaptureType;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.IForward;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;
import org.ocpsoft.rewrite.transform.resolve.ResourceResolver;
import org.ocpsoft.rewrite.transform.resource.FileResource;
import org.ocpsoft.rewrite.transform.resource.Resource;

public class WebResourceResolver
implements ResourceResolver {
    private final ParameterizedPattern pattern;
    private final ParameterStore<IForward.ForwardParameter> parameters = new ParameterStore();

    public static WebResourceResolver named(String pattern) {
        return new WebResourceResolver(pattern);
    }

    public static WebResourceResolver identity() {
        return new WebResourceResolver(null);
    }

    private WebResourceResolver(String pattern) {
        this.pattern = pattern != null ? new ParameterizedPattern(CaptureType.BRACE, "[^/]+", pattern) : null;
    }

    @Override
    public Resource getResource(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpServletRewrite) {
            File resource;
            HttpServletRewrite httpServletRewrite = (HttpServletRewrite)event;
            String path = null;
            path = this.pattern != null ? this.pattern.build(event, context, this.parameters.getParameters()) : httpServletRewrite.getRequestPath();
            ServletContext servletContext = ((HttpServletRequest)httpServletRewrite.getRequest()).getServletContext();
            String realPath = servletContext.getRealPath(path);
            if (realPath != null && (resource = new File(realPath)).isFile() && resource.canRead()) {
                return new FileResource(resource);
            }
        }
        return null;
    }
}

