/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.ocpsoft.common.util.Streams;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContent;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptor;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptorChain;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.transform.Transformer;

class PipelineContentInterceptor
implements ResponseContentInterceptor {
    private List<Transformer> pipeline = new ArrayList<Transformer>();

    PipelineContentInterceptor() {
    }

    public void add(Transformer transformer) {
        this.pipeline.add(transformer);
    }

    public void intercept(HttpServletRewrite event, ResponseContent buffer, ResponseContentInterceptorChain chain) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.transform(new ByteArrayInputStream(buffer.getContents()), output);
            buffer.setContents(output.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to apply transformation pipeline", e);
        }
    }

    public void transform(InputStream input, OutputStream output) throws IOException {
        if (this.pipeline.isEmpty()) {
            Streams.copy((InputStream)input, (OutputStream)output);
        } else if (this.pipeline.size() == 1) {
            this.pipeline.get(0).transform(input, output);
        } else {
            InputStream in = input;
            OutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < this.pipeline.size(); ++i) {
                this.pipeline.get(i).transform(in, out);
                if (i >= this.pipeline.size() - 1) continue;
                ByteArrayOutputStream lastOutput = out;
                in = new ByteArrayInputStream(lastOutput.toByteArray());
                if (i == this.pipeline.size() - 2) {
                    out = output;
                    continue;
                }
                lastOutput.reset();
            }
        }
    }
}

