/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.transform;

import javax.servlet.ServletRequest;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.RewriteWrappedResponse;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptor;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.transform.PipelineContentInterceptor;
import org.ocpsoft.rewrite.transform.Transformer;

public class Transform
extends HttpOperation {
    private PipelineContentInterceptor pipeline = new PipelineContentInterceptor();

    public static Transform with(Class<? extends Transformer> transformerType) {
        return new Transform().apply(transformerType);
    }

    public Transform apply(Class<? extends Transformer> transformerType) {
        try {
            return this.apply(transformerType.newInstance());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Transform apply(Class<? extends Transformer> first, Class<? extends Transformer> second, Class<? extends Transformer> third) {
        this.apply(first);
        this.apply(second);
        this.apply(third);
        return this;
    }

    public Transform apply(Class<? extends Transformer> first, Class<? extends Transformer> second) {
        this.apply(first);
        this.apply(second);
        return this;
    }

    public Transform apply(Class<? extends Transformer> ... transformerTypes) {
        for (Class<? extends Transformer> transformerType : transformerTypes) {
            this.apply(transformerType);
        }
        return this;
    }

    public Transform apply(Transformer ... transformers) {
        for (Transformer transformer : transformers) {
            this.pipeline.add(transformer);
        }
        return this;
    }

    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            RewriteWrappedResponse.getCurrentInstance((ServletRequest)event.getRequest()).addContentInterceptor((ResponseContentInterceptor)this.pipeline);
        }
    }
}

