/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.showcase.bookstore.dao;

import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.ocpsoft.rewrite.showcase.bookstore.model.Book;
import org.ocpsoft.rewrite.showcase.bookstore.model.Category;

@Stateless
public class BookDao {
    @PersistenceContext
    private EntityManager entityManager;

    public List<Book> findByCategory(Category category) {
        return this.entityManager.createQuery("SELECT b FROM Book b WHERE b.category = :category ORDER BY b.title", Book.class).setParameter("category", (Object)category).getResultList();
    }

    public Book getByIsbn(Long isbn) {
        try {
            return (Book)this.entityManager.createQuery("SELECT b FROM Book b WHERE b.isbn = :isbn", Book.class).setParameter("isbn", (Object)isbn).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Book> findByQuery(String query) {
        return this.entityManager.createQuery("SELECT b FROM Book b WHERE LOWER(b.title) LIKE :query OR LOWER(b.author) LIKE :query ORDER BY b.title", Book.class).setParameter("query", (Object)("%" + query.toLowerCase() + "%")).getResultList();
    }

    public List<Book> findByYear(Integer year) {
        return this.entityManager.createQuery("SELECT b FROM Book b WHERE b.year= :year ORDER BY b.title", Book.class).setParameter("year", (Object)year).getResultList();
    }
}

