/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.showcase.bookstore.dao;

import java.io.InputStream;
import java.sql.SQLException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.sql.DataSource;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseDataSourceConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.dbunit.operation.DatabaseOperation;

@Singleton
@Startup
public class DatabaseInitializer {
    @Resource(mappedName="java:jboss/datasources/ExampleDS")
    private DataSource dataSource;

    @PostConstruct
    public void init() {
        try {
            DatabaseDataSourceConnection connection = new DatabaseDataSourceConnection(this.dataSource);
            connection.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new H2DataTypeFactory());
            InputStream datasetStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("dataset.xml");
            FlatXmlDataSet dataset = new FlatXmlDataSetBuilder().build(datasetStream);
            DatabaseOperation.CLEAN_INSERT.execute((IDatabaseConnection)connection, (IDataSet)dataset);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
        catch (DataSetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (DatabaseUnitException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

