/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.showcase.bookstore.web.details;

import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.ocpsoft.rewrite.annotation.Join;
import org.ocpsoft.rewrite.annotation.Parameter;
import org.ocpsoft.rewrite.annotation.RequestAction;
import org.ocpsoft.rewrite.annotation.Rule;
import org.ocpsoft.rewrite.faces.annotation.Deferred;
import org.ocpsoft.rewrite.faces.navigate.Navigate;
import org.ocpsoft.rewrite.showcase.bookstore.dao.BookDao;
import org.ocpsoft.rewrite.showcase.bookstore.model.Book;
import org.ocpsoft.rewrite.showcase.bookstore.web.cart.Cart;
import org.ocpsoft.rewrite.showcase.bookstore.web.utils.ResponseUtils;

@Named
@RequestScoped
@Rule(value="book")
@Join(path="/buch/{isbn}", to="/faces/book.xhtml")
public class BookBean {
    @Parameter
    private Long isbn;
    private Book book;
    @EJB
    private BookDao bookDao;
    @Inject
    private Cart cartBean;

    @RequestAction
    @Deferred
    public String loadData() {
        this.book = this.bookDao.getByIsbn(this.isbn);
        if (this.book == null) {
            ResponseUtils.sendError((int)404);
            return null;
        }
        return null;
    }

    public Navigate addToCart() {
        this.cartBean.addBook(this.book);
        return Navigate.to(BookBean.class).with((CharSequence)"isbn", (Object)this.isbn);
    }

    public Long getIsbn() {
        return this.isbn;
    }

    public void setIsbn(Long isbn) {
        this.isbn = isbn;
    }

    public Book getBook() {
        return this.book;
    }
}

