/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.showcase.bookstore.web.list;

import java.util.List;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import org.ocpsoft.rewrite.annotation.Join;
import org.ocpsoft.rewrite.annotation.Parameter;
import org.ocpsoft.rewrite.annotation.RequestAction;
import org.ocpsoft.rewrite.faces.annotation.Deferred;
import org.ocpsoft.rewrite.showcase.bookstore.dao.BookDao;
import org.ocpsoft.rewrite.showcase.bookstore.dao.CategoryDao;
import org.ocpsoft.rewrite.showcase.bookstore.model.Book;
import org.ocpsoft.rewrite.showcase.bookstore.model.Category;
import org.ocpsoft.rewrite.showcase.bookstore.web.utils.ResponseUtils;

@Named
@RequestScoped
@Join(path="/category/{seoKey}", to="/faces/category.xhtml")
public class CategoryBean {
    @Parameter
    private String seoKey;
    @EJB
    private CategoryDao categoryDao;
    @EJB
    private BookDao bookDao;
    private List<Book> books;

    @RequestAction
    @Deferred
    public String loadData() {
        Category category = this.categoryDao.getBySeoKey(this.seoKey);
        if (category == null) {
            ResponseUtils.sendError((int)404);
            return null;
        }
        this.books = this.bookDao.findByCategory(category);
        return null;
    }

    public List<Book> getBooks() {
        return this.books;
    }

    public String getSeoKey() {
        return this.seoKey;
    }

    public void setSeoKey(String seoKey) {
        this.seoKey = seoKey;
    }
}

