/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.showcase.bookstore.web.cart;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.ocpsoft.rewrite.annotation.Join;
import org.ocpsoft.rewrite.annotation.RequestAction;
import org.ocpsoft.rewrite.faces.annotation.Deferred;
import org.ocpsoft.rewrite.showcase.bookstore.model.Book;
import org.ocpsoft.rewrite.showcase.bookstore.web.cart.Cart;

@Named
@RequestScoped
@Join(path="/cart", to="/faces/cart.xhtml")
public class CartBean {
    @Inject
    private Cart cart;
    private List<Book> books;
    private float sum;

    @RequestAction
    @Deferred
    public void init() {
        this.books = this.cart.getBooks();
        this.sum = 0.0f;
        for (Book book : this.books) {
            this.sum += book.getPrice().floatValue();
        }
    }

    public List<Book> getBooks() {
        return this.books;
    }

    public float getSum() {
        return this.sum;
    }
}

