/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.showcase.bookstore.web.details;

import jakarta.ejb.EJB;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.ocpsoft.rewrite.annotation.Join;
import org.ocpsoft.rewrite.annotation.Parameter;
import org.ocpsoft.rewrite.annotation.RequestAction;
import org.ocpsoft.rewrite.faces.annotation.Deferred;
import org.ocpsoft.rewrite.showcase.bookstore.service.BookImageService;
import org.ocpsoft.rewrite.showcase.bookstore.web.utils.ResponseUtils;

@Named
@RequestScoped
@Join(path="/images/book/{isbn}.jpg", to="/faces/home.xhtml")
public class BookImageBean {
    @Parameter
    private Long isbn;
    @EJB
    private BookImageService bookImageService;

    @RequestAction
    @Deferred
    public void getImage() throws IOException {
        byte[] image = this.bookImageService.getBookImage(this.isbn);
        if (image == null) {
            ResponseUtils.sendError((int)404);
            return;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("image/jpg");
        response.getOutputStream().write(image);
        response.flushBuffer();
        facesContext.responseComplete();
    }

    public Long getIsbn() {
        return this.isbn;
    }

    public void setIsbn(Long isbn) {
        this.isbn = isbn;
    }
}

