/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.showcase.bookstore.dao;

import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ocpsoft.rewrite.showcase.bookstore.dao.TestDataRepository;
import org.ocpsoft.rewrite.showcase.bookstore.model.Book;
import org.ocpsoft.rewrite.showcase.bookstore.model.Category;

@Stateless
public class BookDao {
    @Inject
    private TestDataRepository repository;

    public List<Book> findByCategory(Category category) {
        ArrayList<Book> result = new ArrayList<Book>();
        for (Book book : this.repository.getBooks()) {
            if (!book.getCategory().equals((Object)category)) continue;
            result.add(book);
        }
        return Collections.unmodifiableList(result);
    }

    public Book getByIsbn(Long isbn) {
        for (Book book : this.repository.getBooks()) {
            if (!book.getIsbn().equals(isbn)) continue;
            return book;
        }
        return null;
    }

    public List<Book> findByQuery(String query) {
        ArrayList<Book> result = new ArrayList<Book>();
        for (Book book : this.repository.getBooks()) {
            if (!book.getTitle().toLowerCase().contains(query.toLowerCase()) && !book.getAuthor().toLowerCase().contains(query.toLowerCase())) continue;
            result.add(book);
        }
        return Collections.unmodifiableList(result);
    }

    public List<Book> findByYear(Integer year) {
        ArrayList<Book> result = new ArrayList<Book>();
        for (Book book : this.repository.getBooks()) {
            if (!book.getYear().equals(year)) continue;
            result.add(book);
        }
        return Collections.unmodifiableList(result);
    }
}

