/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.showcase.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import org.ocpsoft.rewrite.showcase.rest.Product;

@ApplicationScoped
@XmlRootElement(name="products")
public class ProductRegistry {
    private final List<Product> products = new ArrayList();

    public ProductRegistry() {
        this.add(new Product("Football Ticket", "Tickets to see your favorite football team. We know your favorite.", 65.99));
        this.add(new Product("Baseball Cap", "Always stylish, sometimes practical; forward use only.", 15.99));
        this.add(new Product("Snug-fit Swim Trunks", "Somehow not as interesting as the female counterpart.", 20.99));
        this.add(new Product("Purple 2-Piece Bikini", "Who doesn't like purple?", 30.99));
    }

    public Product getById(int id) {
        if (id < 0 || id > this.products.size() - 1) {
            throw new RuntimeException("No product with id [" + id + "]");
        }
        return (Product)this.products.get(id);
    }

    @XmlElement(name="product", type=Product.class)
    public List<Product> getProducts() {
        return this.products;
    }

    public Product add(Product product) {
        this.products.add(product);
        product.setId(this.products.indexOf(product));
        return product;
    }
}

