/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices.auth;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.accessservices.auth.TokenAuthService;
import org.odpi.openmetadata.userinterface.accessservices.auth.TokenUser;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.ldap.userdetails.InetOrgPerson;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class LoginFilter
extends AbstractAuthenticationProcessingFilter {
    private TokenAuthService tokenAuthenticationService;

    protected LoginFilter(String urlMapping, AuthenticationManager authenticationManager, TokenAuthService tokenAuthenticationService) {
        super((RequestMatcher)new AntPathRequestMatcher(urlMapping));
        this.setAuthenticationManager(authenticationManager);
        this.tokenAuthenticationService = tokenAuthenticationService;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        return this.getAuthenticationManager().authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)request.getParameter("username"), (Object)request.getParameter("password")));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authentication) throws IOException, ServletException {
        TokenUser token = authentication.getPrincipal() instanceof TokenUser ? (TokenUser)authentication.getPrincipal() : new TokenUser((InetOrgPerson)authentication.getPrincipal());
        this.tokenAuthenticationService.addAuthentication(response, token);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        request.getSession().setAttribute("user", (Object)token.getUser());
    }
}

