/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.accessservices.auth.TokenUser;
import org.odpi.openmetadata.userinterface.accessservices.auth.UserAuthentication;
import org.odpi.openmetadata.userinterface.accessservices.domain.User;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class TokenAuthService {
    private static final long VALIDITY_TIME_MS = 1800000L;
    private static final String AUTH_HEADER_NAME = "x-auth-token";
    @Value(value="${token.secret}")
    private String secret;

    public String addAuthentication(HttpServletResponse response, TokenUser tokenUser) {
        String token = this.createTokenForUser(tokenUser.getUser());
        response.addHeader(AUTH_HEADER_NAME, token);
        return token;
    }

    public Authentication getAuthentication(HttpServletRequest request) {
        TokenUser user;
        String token = request.getHeader(AUTH_HEADER_NAME);
        if (token != null && !token.isEmpty() && (user = this.parseUserFromToken(token)) != null) {
            return new UserAuthentication(user);
        }
        return null;
    }

    public TokenUser parseUserFromToken(String token) {
        String userJSON = ((Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody()).getSubject();
        return new TokenUser(this.fromJSON(userJSON));
    }

    public String createTokenForUser(User user) {
        return Jwts.builder().setExpiration(new Date(System.currentTimeMillis() + 1800000L)).setSubject(this.toJSON(user)).signWith(SignatureAlgorithm.HS512, this.secret).compact();
    }

    private User fromJSON(String userJSON) {
        try {
            return (User)new ObjectMapper().readValue(userJSON, User.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String toJSON(User user) {
        try {
            return new ObjectMapper().writeValueAsString((Object)user);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

