/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices.service;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.client.AssetCatalog;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Classification;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetCatalogOMASService {
    private final AssetCatalog assetCatalog;
    private static final Logger LOG = LoggerFactory.getLogger(AssetCatalogOMASService.class);
    private final String user = "demo";

    @Autowired
    public AssetCatalogOMASService(AssetCatalog assetCatalog) {
        this.assetCatalog = assetCatalog;
    }

    public List<AssetDescription> searchAssets(String searchCriteria) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.searchAssets("demo", searchCriteria).getAssetDescriptionList();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset details for '%s'", searchCriteria));
            throw e;
        }
    }

    public List<AssetDescription> getAssetSummary(String assetId) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetSummary("demo", assetId).getAssetDescriptionList();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset description for %s", assetId));
            throw e;
        }
    }

    public List<AssetDescription> getAssetDetails(String assetId) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetDetails("demo", assetId).getAssetDescriptionList();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset details for %s", assetId));
            throw e;
        }
    }

    public List<AssetDescription> getAssetUniverse(String assetId) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetUniverse("demo", assetId).getAssetDescriptionList();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset universe for %s", assetId));
            throw e;
        }
    }

    public List<Relationship> getAssetRelationships(String assetId) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetRelationships("demo", assetId).getRelationships();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset relationships for %s", assetId));
            throw e;
        }
    }

    public List<Relationship> getAssetRelationshipsForType(String assetId, String relationshipType) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetRelationshipsForType("demo", assetId, relationshipType).getRelationships();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset relationships for %s and relationship type %s", assetId, relationshipType));
            throw e;
        }
    }

    public List<Classification> getClassificationForAsset(String assetId) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getClassificationForAsset("demo", assetId).getClassifications();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset classifications for %s", assetId));
            throw e;
        }
    }
}

