define(["exports","./my-app.js"],function(_exports,_myApp){"use strict";Object.defineProperty(_exports,"__esModule",{value:!0});_exports.NeonSharedElementAnimationBehaviorImpl=_exports.NeonSharedElementAnimationBehavior=_exports.$neonSharedElementAnimationBehavior=void 0;const NeonSharedElementAnimationBehaviorImpl={properties:{/**
     * Cached copy of shared elements.
     */sharedElements:{type:Object}},/**
   * Finds shared elements based on `config`.
   */findSharedElements:function(config){var fromPage=config.fromPage,toPage=config.toPage;if(!fromPage||!toPage){console.warn(this.is+":",!fromPage?"fromPage":"toPage","is undefined!");return null};if(!fromPage.sharedElements||!toPage.sharedElements){console.warn(this.is+":","sharedElements are undefined for",!fromPage.sharedElements?fromPage:toPage);return null};var from=fromPage.sharedElements[config.id],to=toPage.sharedElements[config.id];if(!from||!to){console.warn(this.is+":","sharedElement with id",config.id,"not found in",!from?fromPage:toPage);return null}this.sharedElements={from:from,to:to};return this.sharedElements}};/** @polymerBehavior */_exports.NeonSharedElementAnimationBehaviorImpl=NeonSharedElementAnimationBehaviorImpl;const NeonSharedElementAnimationBehavior=[_myApp.NeonAnimationBehavior,NeonSharedElementAnimationBehaviorImpl];_exports.NeonSharedElementAnimationBehavior=NeonSharedElementAnimationBehavior;var neonSharedElementAnimationBehavior={NeonSharedElementAnimationBehaviorImpl:NeonSharedElementAnimationBehaviorImpl,NeonSharedElementAnimationBehavior:NeonSharedElementAnimationBehavior};_exports.$neonSharedElementAnimationBehavior=neonSharedElementAnimationBehavior;(0,_myApp.Polymer)({is:"ripple-animation",behaviors:[NeonSharedElementAnimationBehavior],configure:function(config){var shared=this.findSharedElements(config);if(!shared){return null}var translateX,translateY,toRect=shared.to.getBoundingClientRect();if(config.gesture){translateX=config.gesture.x-(toRect.left+toRect.width/2);translateY=config.gesture.y-(toRect.top+toRect.height/2)}else{var fromRect=shared.from.getBoundingClientRect();translateX=fromRect.left+fromRect.width/2-(toRect.left+toRect.width/2);translateY=fromRect.top+fromRect.height/2-(toRect.top+toRect.height/2)}var translate="translate("+translateX+"px,"+translateY+"px)",size=Math.max(toRect.width+2*Math.abs(translateX),toRect.height+2*Math.abs(translateY)),diameter=Math.sqrt(2*size*size),scaleX=diameter/toRect.width,scaleY=diameter/toRect.height,scale="scale("+scaleX+","+scaleY+")";this._effect=new KeyframeEffect(shared.to,[{transform:translate+" scale(0)"},{transform:translate+" "+scale}],this.timingFromConfig(config));this.setPrefixedProperty(shared.to,"transformOrigin","50% 50%");shared.to.style.borderRadius="50%";return this._effect},complete:function(){if(this.sharedElements){this.setPrefixedProperty(this.sharedElements.to,"transformOrigin","");this.sharedElements.to.style.borderRadius=""}}});(0,_myApp.Polymer)({_template:_myApp.html`
    <style>
      :host {
        overflow: hidden; /* needed for text-overflow: ellipsis to work on ff */
        @apply --layout-vertical;
        @apply --layout-center-justified;
        @apply --layout-flex;
      }

      :host([two-line]) {
        min-height: var(--paper-item-body-two-line-min-height, 72px);
      }

      :host([three-line]) {
        min-height: var(--paper-item-body-three-line-min-height, 88px);
      }

      :host > ::slotted(*) {
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
      }

      :host > ::slotted([secondary]) {
        @apply --paper-font-body1;

        color: var(--paper-item-body-secondary-color, var(--secondary-text-color));

        @apply --paper-item-body-secondary;
      }
    </style>

    <slot></slot>
`,is:"paper-item-body"});(0,_myApp.Polymer)({_template:_myApp.html`
    <style include="paper-item-shared-styles"></style>
    <style>
      :host {
        @apply --layout-horizontal;
        @apply --layout-center;
        @apply --paper-font-subhead;

        @apply --paper-item;
        @apply --paper-icon-item;
      }

      .content-icon {
        @apply --layout-horizontal;
        @apply --layout-center;

        width: var(--paper-item-icon-width, 56px);
        @apply --paper-item-icon;
      }
    </style>

    <div id="contentIcon" class="content-icon">
      <slot name="item-icon"></slot>
    </div>
    <slot></slot>
`,is:"paper-icon-item",behaviors:[_myApp.PaperItemBehavior]});class DataView extends _myApp.PolymerElement{static get template(){return _myApp.html$1`
      <style include="shared-styles">
        :host {
          display: block;
          padding: 10px 20px;
        }
        
      </style>
      <token-ajax id="tokenAjax" last-response="{{searchResp}}"></token-ajax>
      
      <vaadin-grid id="grid" items="{{data.records}}" theme="row-stripes"
                     on-active-item-changed="_onActiveItemChanged"
                     column-reordering-allowed multi-sort
                     page-size="15" height-by-rows>

            <template is="dom-repeat" items="[[data.columns]]" as="column">

                <vaadin-grid-column>
                    <template class="header">
                        <span  class$="[[_getStyleClass(column)]]">[[_getColumnHeader(column)]]</span>
                    </template>
                    <template>
                        <span class$="[[_getStyleClass(column)]]">
                            [[get(column, item)]]
                        </span>
                    </template>
                </vaadin-grid-column>
            </template>

      </vaadin-grid>
       
    `}static get properties(){return{data:{type:Array,notify:!0}}}_search(){this.$.searchForm.validate();console.log("searching: "+this.q);this.$.tokenAjax.url="/api/assets/search?q="+this.q;this.$.tokenAjax._go()}}window.customElements.define("data-view",DataView)});