/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices;

import org.odpi.openmetadata.accessservices.assetcatalog.client.AssetCatalog;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineage;
import org.odpi.openmetadata.http.HttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@SpringBootApplication
@ComponentScan(value={"org.odpi.openmetadata.*"})
@Configuration
public class EgeriaUIApplication {
    private static final Logger LOG = LoggerFactory.getLogger(EgeriaUIApplication.class);
    @Value(value="${strict.ssl}")
    Boolean strictSSL;

    public static void main(String[] args) {
        SpringApplication.run(EgeriaUIApplication.class, (String[])args);
    }

    @Bean
    public InitializingBean getInitialize() {
        return () -> {
            if (!this.strictSSL.booleanValue()) {
                HttpHelper.noStrictSSL();
            }
        };
    }

    @Bean
    public AssetCatalog getAssetCatalog(@Value(value="${omas.server.url}") String serverUrl, @Value(value="${omas.server.name}") String serverName) {
        return new AssetCatalog(serverName, serverUrl);
    }

    @Bean
    public SubjectArea getSubjectArea(@Value(value="${omas.server.url}") String serverUrl, @Value(value="${omas.server.name}") String serverName) throws InvalidParameterException {
        return new SubjectAreaImpl(serverName, serverUrl);
    }

    @Bean
    public OpenLineage getOpenLineage(@Value(value="${open.lineage.server.url}") String serverUrl, @Value(value="${open.lineage.server.name}") String serverName) {
        return new OpenLineage(serverName, serverUrl);
    }
}

