/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices.api;

import java.util.Map;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.AssetCatalogException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.PropertyServerException;
import org.odpi.openmetadata.userinterface.accessservices.api.CustomErrorAttributes;
import org.odpi.openmetadata.userinterface.accessservices.api.MalformedInputException;
import org.odpi.openmetadata.userinterface.accessservices.api.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class ExceptionHandlerController
extends ResponseEntityExceptionHandler {
    @Autowired
    private CustomErrorAttributes errorAttributes;
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandlerController.class);

    @ExceptionHandler(value={MalformedInputException.class})
    protected ResponseEntity<Object> handleMalformedInput(MalformedInputException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        String bodyOfResponse = "Received response does not have the expected format.";
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, bodyOfResponse, httpStatus);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), httpStatus, request);
    }

    @ExceptionHandler(value={InvalidParameterException.class, PropertyServerException.class, InvalidParameterException.class})
    protected ResponseEntity<Object> handleAssetCatalogException(AssetCatalogException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        String bodyOfResponse = "Invalid request to asset catalog.";
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, bodyOfResponse, httpStatus);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), httpStatus, request);
    }

    @ExceptionHandler(value={RestClientException.class})
    protected ResponseEntity<Object> handleResourceException(RestClientException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        String bodyOfResponse = "Unable to access resource.";
        HttpStatus httpStatus = HttpStatus.SERVICE_UNAVAILABLE;
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, bodyOfResponse, httpStatus);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), httpStatus, request);
    }

    @ExceptionHandler(value={UserNotAuthorizedException.class})
    protected ResponseEntity<Object> handleUnauthorizedException(UserNotAuthorizedException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        HttpStatus httpStatus = HttpStatus.UNAUTHORIZED;
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, "Unauthorized user.", httpStatus);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), httpStatus, request);
    }
}

