/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices.api;

import java.beans.PropertyEditor;
import java.util.Map;
import org.odpi.openmetadata.governanceservers.openlineage.converters.ScopeEnumConverter;
import org.odpi.openmetadata.governanceservers.openlineage.converters.ViewEnumConverter;
import org.odpi.openmetadata.governanceservers.openlineage.model.GraphName;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.model.View;
import org.odpi.openmetadata.userinterface.accessservices.service.OpenLineageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lineage"})
public class OpenLineageController {
    @Autowired
    private OpenLineageService openLineageService;

    @RequestMapping(method={RequestMethod.GET}, value={"/export"})
    public Map<String, Object> exportGraph(@RequestParam GraphName graphName) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Map exportedGraph = this.openLineageService.exportGraph(userId);
        return exportedGraph;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/entities/{guid}/ultimate-source"})
    public Map<String, Object> ultimateSourceGraph(@PathVariable(value="guid") String guid, @RequestParam View view) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Map exportedGraph = this.openLineageService.getUltimateSource(userId, view, guid);
        return exportedGraph;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/entities/{guid}/end2end"})
    @ResponseBody
    public Map<String, Object> endToEndLineage(@PathVariable(value="guid") String guid, @RequestParam View view) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Map exportedGraph = this.openLineageService.getEndToEndLineage(userId, view, guid);
        return exportedGraph;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/entities/{guid}/ultimate-destination"})
    public Map<String, Object> ultimateDestination(@PathVariable(value="guid") String guid, @RequestParam View view) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Map exportedGraph = this.openLineageService.getUltimateDestination(userId, view, guid);
        return exportedGraph;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/entities/{guid}/glossary-lineage"})
    public Map<String, Object> glossaryLineage(@PathVariable(value="guid") String guid, @RequestParam View view) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Map exportedGraph = this.openLineageService.getGlossaryLineage(userId, view, guid);
        return exportedGraph;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/entities/{guid}/source-and-destination"})
    public Map<String, Object> sourceAndDestinationLineage(@PathVariable(value="guid") String guid, @RequestParam View view) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Map exportedGraph = this.openLineageService.getSourceAndDestination(userId, view, guid);
        return exportedGraph;
    }

    @InitBinder
    public void initBinder(WebDataBinder webdataBinder) {
        webdataBinder.registerCustomEditor(View.class, (PropertyEditor)new ViewEnumConverter());
        webdataBinder.registerCustomEditor(Scope.class, (PropertyEditor)new ScopeEnumConverter());
    }
}

