/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices.api;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossariesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.userinterface.accessservices.api.SecureController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subject-area/glossaries"})
@DependsOn(value={"securityConfig"})
public class SubjectAreaGlossaryController
extends SecureController {
    private final SubjectArea subjectArea;
    private static String className = SubjectAreaGlossaryController.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)className);
    private final SubjectAreaGlossary subjectAreaGlossary;

    public SubjectAreaGlossaryController(SubjectArea subjectArea) {
        this.subjectArea = subjectArea;
        this.subjectAreaGlossary = subjectArea.getSubjectAreaGlossary();
    }

    @RequestMapping(method={RequestMethod.POST})
    public SubjectAreaOMASAPIResponse createGlossary(@RequestBody Glossary suppliedGlossary, HttpServletRequest request) {
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Glossary glossary = this.subjectAreaGlossary.createGlossary(serverName, userId, suppliedGlossary);
            GlossaryResponse glossaryResponse = new GlossaryResponse();
            glossaryResponse.setGlossary(glossary);
            response = glossaryResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/{guid}"})
    public SubjectAreaOMASAPIResponse getGlossary(@PathVariable String guid, HttpServletRequest request) {
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Glossary glossary = this.subjectAreaGlossary.getGlossaryByGuid(serverName, userId, guid);
            GlossaryResponse glossaryResponse = new GlossaryResponse();
            glossaryResponse.setGlossary(glossary);
            response = glossaryResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.GET})
    public SubjectAreaOMASAPIResponse findGlossary(@RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty, HttpServletRequest request) {
        SubjectAreaOMASAPIResponse response;
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        try {
            if (offset == null) {
                offset = new Integer(0);
            }
            if (pageSize == null) {
                pageSize = new Integer(0);
            }
            List glossaries = this.subjectAreaGlossary.findGlossary(serverName, userId, searchCriteria, asOfTime, offset.intValue(), pageSize.intValue(), sequencingOrder, sequencingProperty);
            GlossariesResponse glossariesResponse = new GlossariesResponse();
            glossariesResponse.setGlossaries(glossaries);
            response = glossariesResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getGlossaryRelationships(@PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty, HttpServletRequest request) {
        SubjectAreaOMASAPIResponse response;
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        try {
            List lines = this.subjectAreaGlossary.getGlossaryRelationships(serverName, userId, guid, asOfTime, offset.intValue(), pageSize.intValue(), sequencingOrder, sequencingProperty);
            LinesResponse linesResponse = new LinesResponse();
            linesResponse.setLines(lines);
            response = linesResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/{guid}"})
    public SubjectAreaOMASAPIResponse updateGlossary(@PathVariable String guid, @RequestBody Glossary glossary, @RequestParam(value="isReplace", required=false) Boolean isReplace, HttpServletRequest request) {
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            if (isReplace == null) {
                isReplace = false;
            }
            Glossary updatedGlossary = isReplace != false ? this.subjectAreaGlossary.replaceGlossary(serverName, userId, guid, glossary) : this.subjectAreaGlossary.updateGlossary(serverName, userId, guid, glossary);
            GlossaryResponse glossaryResponse = new GlossaryResponse();
            glossaryResponse.setGlossary(updatedGlossary);
            response = glossaryResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/{guid}"})
    public SubjectAreaOMASAPIResponse deleteGlossary(@PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge, HttpServletRequest request) {
        if (isPurge == null) {
            isPurge = false;
        }
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            if (isPurge.booleanValue()) {
                this.subjectAreaGlossary.purgeGlossary(serverName, userId, guid);
                response = new VoidResponse();
            } else {
                Glossary glossary = this.subjectAreaGlossary.deleteGlossary(serverName, userId, guid);
                GlossaryResponse glossaryResponse = new GlossaryResponse();
                glossaryResponse.setGlossary(glossary);
                response = glossaryResponse;
            }
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/{guid}"})
    public SubjectAreaOMASAPIResponse restoreGlossary(@PathVariable String guid, HttpServletRequest request) {
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Glossary glossary = this.subjectAreaGlossary.restoreGlossary(serverName, userId, guid);
            GlossaryResponse glossaryResponse = new GlossaryResponse();
            glossaryResponse.setGlossary(glossary);
            response = glossaryResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }
}

