/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices.api;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaProject;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.userinterface.accessservices.api.SecureController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subject-area/projects"})
public class SubjectAreaProjectController
extends SecureController {
    private final SubjectArea subjectArea;
    private static String className = SubjectAreaProjectController.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)className);
    private final SubjectAreaProject subjectAreaProject;

    public SubjectAreaProjectController(SubjectArea subjectArea) {
        this.subjectArea = subjectArea;
        this.subjectAreaProject = subjectArea.getSubjectAreaProject();
    }

    @RequestMapping(method={RequestMethod.POST})
    public SubjectAreaOMASAPIResponse createProject(@RequestBody Project suppliedProject, HttpServletRequest request) {
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Project project = this.subjectAreaProject.createProject(serverName, userId, suppliedProject);
            ProjectResponse projectResponse = new ProjectResponse();
            projectResponse.setProject(project);
            response = projectResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/{guid}"})
    public SubjectAreaOMASAPIResponse getProject(@PathVariable String guid, HttpServletRequest request) {
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Project project = this.subjectAreaProject.getProjectByGuid(serverName, userId, guid);
            ProjectResponse projectResponse = new ProjectResponse();
            projectResponse.setProject(project);
            response = projectResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.GET})
    public SubjectAreaOMASAPIResponse findProject(@RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty, HttpServletRequest request) {
        SubjectAreaOMASAPIResponse response;
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        try {
            if (offset == null) {
                offset = new Integer(0);
            }
            if (pageSize == null) {
                pageSize = new Integer(0);
            }
            List projects = this.subjectAreaProject.findProject(serverName, userId, searchCriteria, asOfTime, offset.intValue(), pageSize.intValue(), sequencingOrder, sequencingProperty);
            ProjectsResponse projectsResponse = new ProjectsResponse();
            projectsResponse.setProjects(projects);
            response = projectsResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getProjectRelationships(@PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty, HttpServletRequest request) {
        SubjectAreaOMASAPIResponse response;
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        try {
            List lines = this.subjectAreaProject.getProjectRelationships(serverName, userId, guid, asOfTime, offset.intValue(), pageSize.intValue(), sequencingOrder, sequencingProperty);
            LinesResponse linesResponse = new LinesResponse();
            linesResponse.setLines(lines);
            response = linesResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/{guid}"})
    public SubjectAreaOMASAPIResponse updateProject(@PathVariable String guid, @RequestBody Project project, @RequestParam(value="isReplace", required=false) Boolean isReplace, HttpServletRequest request) {
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            if (isReplace == null) {
                isReplace = false;
            }
            Project updatedProject = isReplace != false ? this.subjectAreaProject.replaceProject(serverName, userId, guid, project) : this.subjectAreaProject.updateProject(serverName, userId, guid, project);
            ProjectResponse projectResponse = new ProjectResponse();
            projectResponse.setProject(updatedProject);
            response = projectResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/{guid}"})
    public SubjectAreaOMASAPIResponse deleteProject(@PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge, HttpServletRequest request) {
        if (isPurge == null) {
            isPurge = false;
        }
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            if (isPurge.booleanValue()) {
                this.subjectAreaProject.purgeProject(serverName, userId, guid);
                response = new VoidResponse();
            } else {
                Project project = this.subjectAreaProject.deleteProject(serverName, userId, guid);
                ProjectResponse projectResponse = new ProjectResponse();
                projectResponse.setProject(project);
                response = projectResponse;
            }
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/{guid}"})
    public SubjectAreaOMASAPIResponse restoreProject(@PathVariable String guid, HttpServletRequest request) {
        String serverName = this.subjectArea.getServerName();
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Project project = this.subjectAreaProject.restoreProject(serverName, userId, guid);
            ProjectResponse projectResponse = new ProjectResponse();
            projectResponse.setProject(project);
            response = projectResponse;
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }
}

