/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices.api.tex;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.userinterface.accessservices.api.tex.ClassificationExplorer;
import org.odpi.openmetadata.userinterface.accessservices.api.tex.EntityExplorer;
import org.odpi.openmetadata.userinterface.accessservices.api.tex.RelationshipExplorer;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TypeExplorer {
    private Map<String, EntityExplorer> entities = new HashMap();
    private Map<String, RelationshipExplorer> relationships = new HashMap();
    private Map<String, ClassificationExplorer> classifications = new HashMap();
    private Map<String, EnumDef> enums = new HashMap();

    public Map<String, EntityExplorer> getEntities() {
        return this.entities;
    }

    public Map<String, RelationshipExplorer> getRelationships() {
        return this.relationships;
    }

    public Map<String, ClassificationExplorer> getClassifications() {
        return this.classifications;
    }

    public Map<String, EnumDef> getEnums() {
        return this.enums;
    }

    public void addEntityExplorer(String entityTypeName, EntityExplorer entityExplorer) {
        this.entities.put(entityTypeName, entityExplorer);
    }

    public void addRelationshipExplorer(String relationshipTypeName, RelationshipExplorer relationshipExplorer) {
        this.relationships.put(relationshipTypeName, relationshipExplorer);
    }

    public void addClassificationExplorer(String classificationTypeName, ClassificationExplorer classificationExplorer) {
        this.classifications.put(classificationTypeName, classificationExplorer);
    }

    public void addEnumExplorer(String enumTypeName, EnumDef enumDef) {
        this.enums.put(enumTypeName, enumDef);
    }

    public void resolve() {
        this.resolveEntities();
        this.resolveRelationships();
        this.resolveClassifications();
    }

    private void resolveEntities() {
        EntityExplorer superTypeExplorer;
        String superTypeName;
        TypeDefLink superType;
        EntityExplorer entityExplorer;
        for (String entityTypeName : this.entities.keySet()) {
            entityExplorer = (EntityExplorer)this.entities.get(entityTypeName);
            superType = entityExplorer.getEntityDef().getSuperType();
            if (superType == null) continue;
            superTypeName = superType.getName();
            superTypeExplorer = (EntityExplorer)this.entities.get(superTypeName);
            superTypeExplorer.addSubTypName(entityTypeName);
        }
        for (String entityTypeName : this.entities.keySet()) {
            entityExplorer = (EntityExplorer)this.entities.get(entityTypeName);
            superType = entityExplorer.getEntityDef().getSuperType();
            while (superType != null) {
                superTypeName = superType.getName();
                superTypeExplorer = (EntityExplorer)this.entities.get(superTypeName);
                EntityDef superDef = superTypeExplorer.getEntityDef();
                List superAttributes = superDef.getPropertiesDefinition();
                entityExplorer.addInheritedAttributes(superAttributes);
                superType = superDef.getSuperType();
            }
        }
    }

    private void resolveRelationships() {
        for (String relationshipTypeName : this.relationships.keySet()) {
            List subTypeNames;
            RelationshipExplorer relationshipExplorer = (RelationshipExplorer)this.relationships.get(relationshipTypeName);
            RelationshipEndDef entityOneDef = relationshipExplorer.getRelationshipDef().getEndDef1();
            RelationshipEndDef entityTwoDef = relationshipExplorer.getRelationshipDef().getEndDef2();
            if (entityOneDef != null) {
                String entityOneTypeName = entityOneDef.getEntityType().getName();
                EntityExplorer entityOneExplorer = (EntityExplorer)this.entities.get(entityOneTypeName);
                entityOneExplorer.addRelationship(relationshipTypeName);
                subTypeNames = entityOneExplorer.getSubTypeNames();
                for (String subTypeName : subTypeNames) {
                    this.addRelationshipToSubType(relationshipTypeName, subTypeName);
                }
            }
            if (entityTwoDef == null) continue;
            String entityTwoTypeName = entityTwoDef.getEntityType().getName();
            EntityExplorer entityTwoExplorer = (EntityExplorer)this.entities.get(entityTwoTypeName);
            entityTwoExplorer.addRelationship(relationshipTypeName);
            subTypeNames = entityTwoExplorer.getSubTypeNames();
            for (String subTypeName : subTypeNames) {
                this.addRelationshipToSubType(relationshipTypeName, subTypeName);
            }
        }
    }

    private void addRelationshipToSubType(String relationshipTypeName, String entityTypeName) {
        EntityExplorer entityExplorer = (EntityExplorer)this.entities.get(entityTypeName);
        entityExplorer.addInheritedRelationship(relationshipTypeName);
        List subTypeNames = entityExplorer.getSubTypeNames();
        if (!subTypeNames.isEmpty()) {
            for (String subTypeName : subTypeNames) {
                this.addRelationshipToSubType(relationshipTypeName, subTypeName);
            }
        }
    }

    private void resolveClassifications() {
        ClassificationExplorer superTypeExplorer;
        String superTypeName;
        TypeDefLink superType;
        ClassificationExplorer classificationExplorer;
        for (String classificationTypeName : this.classifications.keySet()) {
            classificationExplorer = (ClassificationExplorer)this.classifications.get(classificationTypeName);
            List validEntityTypes = classificationExplorer.getClassificationDef().getValidEntityDefs();
            if (validEntityTypes == null) continue;
            for (TypeDefLink entityType : validEntityTypes) {
                String entityTypeName = entityType.getName();
                EntityExplorer entityExplorer = (EntityExplorer)this.entities.get(entityTypeName);
                entityExplorer.addClassification(classificationTypeName);
                List subTypeNames = entityExplorer.getSubTypeNames();
                for (String subTypeName : subTypeNames) {
                    this.addClassificationToSubType(classificationTypeName, subTypeName);
                }
            }
        }
        for (String classificationTypeName : this.classifications.keySet()) {
            classificationExplorer = (ClassificationExplorer)this.classifications.get(classificationTypeName);
            superType = classificationExplorer.getClassificationDef().getSuperType();
            if (superType == null) continue;
            superTypeName = superType.getName();
            superTypeExplorer = (ClassificationExplorer)this.classifications.get(superTypeName);
            superTypeExplorer.addSubTypName(classificationTypeName);
        }
        for (String classificationTypeName : this.classifications.keySet()) {
            classificationExplorer = (ClassificationExplorer)this.classifications.get(classificationTypeName);
            superType = classificationExplorer.getClassificationDef().getSuperType();
            while (superType != null) {
                superTypeName = superType.getName();
                superTypeExplorer = (ClassificationExplorer)this.classifications.get(superTypeName);
                ClassificationDef superDef = superTypeExplorer.getClassificationDef();
                List superAttributes = superDef.getPropertiesDefinition();
                classificationExplorer.addInheritedAttributes(superAttributes);
                superType = superDef.getSuperType();
            }
        }
    }

    private void addClassificationToSubType(String classificationTypeName, String entityTypeName) {
        EntityExplorer entityExplorer = (EntityExplorer)this.entities.get(entityTypeName);
        entityExplorer.addInheritedClassification(classificationTypeName);
        List subTypeNames = entityExplorer.getSubTypeNames();
        if (!subTypeNames.isEmpty()) {
            for (String subTypeName : subTypeNames) {
                this.addClassificationToSubType(classificationTypeName, subTypeName);
            }
        }
    }

    public String toString() {
        return "TypeExplorer{entities=" + this.entities + ", relationships=" + this.relationships + ", classifications=" + this.classifications + '}';
    }
}

