/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.accessservices.auth.AuthService;
import org.odpi.openmetadata.userinterface.accessservices.auth.TokenUser;
import org.odpi.openmetadata.userinterface.accessservices.auth.UserAuthentication;
import org.odpi.openmetadata.userinterface.accessservices.domain.User;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;

public class TokenAuthService
implements AuthService {
    @Value(value="${token.secret}")
    private String secret;

    public User addAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        TokenUser tokenUser = this.getTokenUser(authentication);
        String token = this.createTokenForUser(tokenUser.getUser(), this.secret);
        response.addHeader("x-auth-token", token);
        return tokenUser.getUser();
    }

    public Authentication getAuthentication(HttpServletRequest request) {
        TokenUser user;
        String token = request.getHeader("x-auth-token");
        if (token != null && !token.isEmpty() && (user = this.parseUserFromToken(token, this.secret)) != null) {
            return new UserAuthentication(user);
        }
        return null;
    }
}

